/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.reindex.Destination;
import co.elastic.clients.elasticsearch.core.reindex.Source;
import co.elastic.clients.elasticsearch.transform.Latest;
import co.elastic.clients.elasticsearch.transform.Pivot;
import co.elastic.clients.elasticsearch.transform.RetentionPolicy;
import co.elastic.clients.elasticsearch.transform.Settings;
import co.elastic.clients.elasticsearch.transform.Sync;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateTransformResponse
implements JsonpSerializable {
    private final long createTime;
    private final String description;
    private final Destination dest;
    private final Time frequency;
    private final String id;
    @Nullable
    private final Latest latest;
    @Nullable
    private final Pivot pivot;
    @Nullable
    private final RetentionPolicy retentionPolicy;
    private final Settings settings;
    private final Source source;
    @Nullable
    private final Sync sync;
    private final String version;
    public static final JsonpDeserializer<UpdateTransformResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateTransformResponse::setupUpdateTransformResponseDeserializer);

    private UpdateTransformResponse(Builder builder) {
        this.createTime = ApiTypeHelper.requireNonNull(builder.createTime, this, "createTime");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.dest = ApiTypeHelper.requireNonNull(builder.dest, this, "dest");
        this.frequency = ApiTypeHelper.requireNonNull(builder.frequency, this, "frequency");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.latest = builder.latest;
        this.pivot = builder.pivot;
        this.retentionPolicy = builder.retentionPolicy;
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.sync = builder.sync;
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static UpdateTransformResponse of(Function<Builder, ObjectBuilder<UpdateTransformResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long createTime() {
        return this.createTime;
    }

    public final String description() {
        return this.description;
    }

    public final Destination dest() {
        return this.dest;
    }

    public final Time frequency() {
        return this.frequency;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Latest latest() {
        return this.latest;
    }

    @Nullable
    public final Pivot pivot() {
        return this.pivot;
    }

    @Nullable
    public final RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    public final Settings settings() {
        return this.settings;
    }

    public final Source source() {
        return this.source;
    }

    @Nullable
    public final Sync sync() {
        return this.sync;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("create_time");
        generator.write(this.createTime);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("dest");
        this.dest.serialize(generator, mapper);
        generator.writeKey("frequency");
        this.frequency.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
        if (this.latest != null) {
            generator.writeKey("latest");
            this.latest.serialize(generator, mapper);
        }
        if (this.pivot != null) {
            generator.writeKey("pivot");
            this.pivot.serialize(generator, mapper);
        }
        if (this.retentionPolicy != null) {
            generator.writeKey("retention_policy");
            this.retentionPolicy.serialize(generator, mapper);
        }
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        if (this.sync != null) {
            generator.writeKey("sync");
            this.sync.serialize(generator, mapper);
        }
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupUpdateTransformResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::createTime, JsonpDeserializer.longDeserializer(), "create_time");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::dest, Destination._DESERIALIZER, "dest");
        op.add(Builder::frequency, Time._DESERIALIZER, "frequency");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::latest, Latest._DESERIALIZER, "latest");
        op.add(Builder::pivot, Pivot._DESERIALIZER, "pivot");
        op.add(Builder::retentionPolicy, RetentionPolicy._DESERIALIZER, "retention_policy");
        op.add(Builder::settings, Settings._DESERIALIZER, "settings");
        op.add(Builder::source, Source._DESERIALIZER, "source");
        op.add(Builder::sync, Sync._DESERIALIZER, "sync");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UpdateTransformResponse> {
        private Long createTime;
        private String description;
        private Destination dest;
        private Time frequency;
        private String id;
        @Nullable
        private Latest latest;
        @Nullable
        private Pivot pivot;
        @Nullable
        private RetentionPolicy retentionPolicy;
        private Settings settings;
        private Source source;
        @Nullable
        private Sync sync;
        private String version;

        public final Builder createTime(long value) {
            this.createTime = value;
            return this;
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder dest(Destination value) {
            this.dest = value;
            return this;
        }

        public final Builder dest(Function<Destination.Builder, ObjectBuilder<Destination>> fn) {
            return this.dest(fn.apply(new Destination.Builder()).build());
        }

        public final Builder frequency(Time value) {
            this.frequency = value;
            return this;
        }

        public final Builder frequency(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.frequency(fn.apply(new Time.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder latest(@Nullable Latest value) {
            this.latest = value;
            return this;
        }

        public final Builder latest(Function<Latest.Builder, ObjectBuilder<Latest>> fn) {
            return this.latest(fn.apply(new Latest.Builder()).build());
        }

        public final Builder pivot(@Nullable Pivot value) {
            this.pivot = value;
            return this;
        }

        public final Builder pivot(Function<Pivot.Builder, ObjectBuilder<Pivot>> fn) {
            return this.pivot(fn.apply(new Pivot.Builder()).build());
        }

        public final Builder retentionPolicy(@Nullable RetentionPolicy value) {
            this.retentionPolicy = value;
            return this;
        }

        public final Builder retentionPolicy(Function<RetentionPolicy.Builder, ObjectBuilder<RetentionPolicy>> fn) {
            return this.retentionPolicy(fn.apply(new RetentionPolicy.Builder()).build());
        }

        public final Builder settings(Settings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<Settings.Builder, ObjectBuilder<Settings>> fn) {
            return this.settings(fn.apply(new Settings.Builder()).build());
        }

        public final Builder source(Source value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<Source.Builder, ObjectBuilder<Source>> fn) {
            return this.source(fn.apply(new Source.Builder()).build());
        }

        public final Builder sync(@Nullable Sync value) {
            this.sync = value;
            return this;
        }

        public final Builder sync(Function<Sync.Builder, ObjectBuilder<Sync>> fn) {
            return this.sync(fn.apply(new Sync.Builder()).build());
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateTransformResponse build() {
            this._checkSingleUse();
            return new UpdateTransformResponse(this);
        }
    }
}

