/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.elasticsearch.sql.query.Column;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryResponse
implements JsonpSerializable {
    private final List<Column> columns;
    @Nullable
    private final String cursor;
    private final List<List<JsonData>> rows;
    public static final JsonpDeserializer<QueryResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryResponse::setupQueryResponseDeserializer);

    private QueryResponse(Builder builder) {
        this.columns = ApiTypeHelper.unmodifiable(builder.columns);
        this.cursor = builder.cursor;
        this.rows = ApiTypeHelper.unmodifiableRequired(builder.rows, (Object)this, "rows");
    }

    public static QueryResponse of(Function<Builder, ObjectBuilder<QueryResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Column> columns() {
        return this.columns;
    }

    @Nullable
    public final String cursor() {
        return this.cursor;
    }

    public final List<List<JsonData>> rows() {
        return this.rows;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.columns)) {
            generator.writeKey("columns");
            generator.writeStartArray();
            for (Column column : this.columns) {
                column.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.cursor != null) {
            generator.writeKey("cursor");
            generator.write(this.cursor);
        }
        if (ApiTypeHelper.isDefined(this.rows)) {
            generator.writeKey("rows");
            generator.writeStartArray();
            for (List list : this.rows) {
                generator.writeStartArray();
                if (list != null) {
                    for (JsonData item1 : list) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupQueryResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::columns, JsonpDeserializer.arrayDeserializer(Column._DESERIALIZER), "columns");
        op.add(Builder::cursor, JsonpDeserializer.stringDeserializer(), "cursor");
        op.add(Builder::rows, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER)), "rows");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryResponse> {
        @Nullable
        private List<Column> columns;
        @Nullable
        private String cursor;
        private List<List<JsonData>> rows;

        public final Builder columns(List<Column> list) {
            this.columns = Builder._listAddAll(this.columns, list);
            return this;
        }

        public final Builder columns(Column value, Column ... values) {
            this.columns = Builder._listAdd(this.columns, value, values);
            return this;
        }

        public final Builder columns(Function<Column.Builder, ObjectBuilder<Column>> fn) {
            return this.columns(fn.apply(new Column.Builder()).build(), new Column[0]);
        }

        public final Builder cursor(@Nullable String value) {
            this.cursor = value;
            return this;
        }

        public final Builder rows(List<List<JsonData>> list) {
            this.rows = Builder._listAddAll(this.rows, list);
            return this;
        }

        public final Builder rows(List<JsonData> value, List<JsonData> ... values) {
            this.rows = Builder._listAdd(this.rows, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryResponse build() {
            this._checkSingleUse();
            return new QueryResponse(this);
        }
    }
}

