/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.RealmInfo;
import co.elastic.clients.elasticsearch.security.authenticate.ApiKey;
import co.elastic.clients.elasticsearch.security.authenticate.ServiceToken;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AuthenticateResponse
implements JsonpSerializable {
    @Nullable
    private final ApiKey apiKey;
    private final RealmInfo authenticationRealm;
    @Nullable
    private final String email;
    @Nullable
    private final String fullName;
    private final RealmInfo lookupRealm;
    private final Map<String, JsonData> metadata;
    private final List<String> roles;
    private final String username;
    private final boolean enabled;
    private final String authenticationType;
    @Nullable
    private final ServiceToken token;
    public static final JsonpDeserializer<AuthenticateResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AuthenticateResponse::setupAuthenticateResponseDeserializer);

    private AuthenticateResponse(Builder builder) {
        this.apiKey = builder.apiKey;
        this.authenticationRealm = ApiTypeHelper.requireNonNull(builder.authenticationRealm, this, "authenticationRealm");
        this.email = builder.email;
        this.fullName = builder.fullName;
        this.lookupRealm = ApiTypeHelper.requireNonNull(builder.lookupRealm, this, "lookupRealm");
        this.metadata = ApiTypeHelper.unmodifiableRequired(builder.metadata, (Object)this, "metadata");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, this, "enabled");
        this.authenticationType = ApiTypeHelper.requireNonNull(builder.authenticationType, this, "authenticationType");
        this.token = builder.token;
    }

    public static AuthenticateResponse of(Function<Builder, ObjectBuilder<AuthenticateResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ApiKey apiKey() {
        return this.apiKey;
    }

    public final RealmInfo authenticationRealm() {
        return this.authenticationRealm;
    }

    @Nullable
    public final String email() {
        return this.email;
    }

    @Nullable
    public final String fullName() {
        return this.fullName;
    }

    public final RealmInfo lookupRealm() {
        return this.lookupRealm;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final String username() {
        return this.username;
    }

    public final boolean enabled() {
        return this.enabled;
    }

    public final String authenticationType() {
        return this.authenticationType;
    }

    @Nullable
    public final ServiceToken token() {
        return this.token;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.apiKey != null) {
            generator.writeKey("api_key");
            this.apiKey.serialize(generator, mapper);
        }
        generator.writeKey("authentication_realm");
        this.authenticationRealm.serialize(generator, mapper);
        if (this.email != null) {
            generator.writeKey("email");
            generator.write(this.email);
        }
        if (this.fullName != null) {
            generator.writeKey("full_name");
            generator.write(this.fullName);
        }
        generator.writeKey("lookup_realm");
        this.lookupRealm.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("enabled");
        generator.write(this.enabled);
        generator.writeKey("authentication_type");
        generator.write(this.authenticationType);
        if (this.token != null) {
            generator.writeKey("token");
            this.token.serialize(generator, mapper);
        }
    }

    protected static void setupAuthenticateResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, ApiKey._DESERIALIZER, "api_key");
        op.add(Builder::authenticationRealm, RealmInfo._DESERIALIZER, "authentication_realm");
        op.add(Builder::email, JsonpDeserializer.stringDeserializer(), "email");
        op.add(Builder::fullName, JsonpDeserializer.stringDeserializer(), "full_name");
        op.add(Builder::lookupRealm, RealmInfo._DESERIALIZER, "lookup_realm");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::authenticationType, JsonpDeserializer.stringDeserializer(), "authentication_type");
        op.add(Builder::token, ServiceToken._DESERIALIZER, "token");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AuthenticateResponse> {
        @Nullable
        private ApiKey apiKey;
        private RealmInfo authenticationRealm;
        @Nullable
        private String email;
        @Nullable
        private String fullName;
        private RealmInfo lookupRealm;
        private Map<String, JsonData> metadata;
        private List<String> roles;
        private String username;
        private Boolean enabled;
        private String authenticationType;
        @Nullable
        private ServiceToken token;

        public final Builder apiKey(@Nullable ApiKey value) {
            this.apiKey = value;
            return this;
        }

        public final Builder apiKey(Function<ApiKey.Builder, ObjectBuilder<ApiKey>> fn) {
            return this.apiKey(fn.apply(new ApiKey.Builder()).build());
        }

        public final Builder authenticationRealm(RealmInfo value) {
            this.authenticationRealm = value;
            return this;
        }

        public final Builder authenticationRealm(Function<RealmInfo.Builder, ObjectBuilder<RealmInfo>> fn) {
            return this.authenticationRealm(fn.apply(new RealmInfo.Builder()).build());
        }

        public final Builder email(@Nullable String value) {
            this.email = value;
            return this;
        }

        public final Builder fullName(@Nullable String value) {
            this.fullName = value;
            return this;
        }

        public final Builder lookupRealm(RealmInfo value) {
            this.lookupRealm = value;
            return this;
        }

        public final Builder lookupRealm(Function<RealmInfo.Builder, ObjectBuilder<RealmInfo>> fn) {
            return this.lookupRealm(fn.apply(new RealmInfo.Builder()).build());
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder authenticationType(String value) {
            this.authenticationType = value;
            return this;
        }

        public final Builder token(@Nullable ServiceToken value) {
            this.token = value;
            return this;
        }

        public final Builder token(Function<ServiceToken.Builder, ObjectBuilder<ServiceToken>> fn) {
            return this.token(fn.apply(new ServiceToken.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AuthenticateResponse build() {
            this._checkSingleUse();
            return new AuthenticateResponse(this);
        }
    }
}

