/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.NodeReloadError;
import co.elastic.clients.elasticsearch.nodes.Stats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NodeReloadResult
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<NodeReloadResult> _DESERIALIZER = JsonpDeserializer.lazy(NodeReloadResult::buildNodeReloadResultDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private NodeReloadResult(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private NodeReloadResult(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static NodeReloadResult of(Function<Builder, ObjectBuilder<NodeReloadResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isError() {
        return this._kind == Kind.Error;
    }

    public NodeReloadError error() {
        return (NodeReloadError)TaggedUnionUtils.get(this, Kind.Error);
    }

    public boolean isStats() {
        return this._kind == Kind.Stats;
    }

    public Stats stats() {
        return (Stats)TaggedUnionUtils.get(this, Kind.Stats);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
    }

    private static JsonpDeserializer<NodeReloadResult> buildNodeReloadResultDeserializer() {
        return new UnionDeserializer.Builder<NodeReloadResult, Kind, Object>(NodeReloadResult::new, false).addMember(Kind.Error, NodeReloadError._DESERIALIZER).addMember(Kind.Stats, Stats._DESERIALIZER).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeReloadResult> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<NodeReloadResult> error(NodeReloadError v) {
            this._kind = Kind.Error;
            this._value = v;
            return this;
        }

        public ObjectBuilder<NodeReloadResult> error(Function<NodeReloadError.Builder, ObjectBuilder<NodeReloadError>> fn) {
            return this.error(fn.apply(new NodeReloadError.Builder()).build());
        }

        public ObjectBuilder<NodeReloadResult> stats(Stats v) {
            this._kind = Kind.Stats;
            this._value = v;
            return this;
        }

        public ObjectBuilder<NodeReloadResult> stats(Function<Stats.Builder, ObjectBuilder<Stats>> fn) {
            return this.stats(fn.apply(new Stats.Builder()).build());
        }

        @Override
        public NodeReloadResult build() {
            this._checkSingleUse();
            return new NodeReloadResult(this);
        }
    }

    public static enum Kind {
        Error,
        Stats;

    }
}

