/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RecoveryStartStatus
implements JsonpSerializable {
    private final long checkIndexTime;
    private final String totalTimeInMillis;
    public static final JsonpDeserializer<RecoveryStartStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryStartStatus::setupRecoveryStartStatusDeserializer);

    private RecoveryStartStatus(Builder builder) {
        this.checkIndexTime = ApiTypeHelper.requireNonNull(builder.checkIndexTime, this, "checkIndexTime");
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
    }

    public static RecoveryStartStatus of(Function<Builder, ObjectBuilder<RecoveryStartStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long checkIndexTime() {
        return this.checkIndexTime;
    }

    public final String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("check_index_time");
        generator.write(this.checkIndexTime);
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    protected static void setupRecoveryStartStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::checkIndexTime, JsonpDeserializer.longDeserializer(), "check_index_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RecoveryStartStatus> {
        private Long checkIndexTime;
        private String totalTimeInMillis;

        public final Builder checkIndexTime(long value) {
            this.checkIndexTime = value;
            return this;
        }

        public final Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RecoveryStartStatus build() {
            this._checkSingleUse();
            return new RecoveryStartStatus(this);
        }
    }
}

