/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexSettingsLifecycleStep
implements JsonpSerializable {
    @Nullable
    private final Time waitTimeThreshold;
    public static final JsonpDeserializer<IndexSettingsLifecycleStep> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsLifecycleStep::setupIndexSettingsLifecycleStepDeserializer);

    private IndexSettingsLifecycleStep(Builder builder) {
        this.waitTimeThreshold = builder.waitTimeThreshold;
    }

    public static IndexSettingsLifecycleStep of(Function<Builder, ObjectBuilder<IndexSettingsLifecycleStep>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time waitTimeThreshold() {
        return this.waitTimeThreshold;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.waitTimeThreshold != null) {
            generator.writeKey("wait_time_threshold");
            this.waitTimeThreshold.serialize(generator, mapper);
        }
    }

    protected static void setupIndexSettingsLifecycleStepDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::waitTimeThreshold, Time._DESERIALIZER, "wait_time_threshold");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexSettingsLifecycleStep> {
        @Nullable
        private Time waitTimeThreshold;

        public final Builder waitTimeThreshold(@Nullable Time value) {
            this.waitTimeThreshold = value;
            return this;
        }

        public final Builder waitTimeThreshold(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.waitTimeThreshold(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexSettingsLifecycleStep build() {
            this._checkSingleUse();
            return new IndexSettingsLifecycleStep(this);
        }
    }
}

