/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.snapshots;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SnapshotsRecord
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final String repository;
    @Nullable
    private final String status;
    @Nullable
    private final String startEpoch;
    @Nullable
    private final String startTime;
    @Nullable
    private final String endEpoch;
    @Nullable
    private final String endTime;
    @Nullable
    private final Time duration;
    @Nullable
    private final String indices;
    @Nullable
    private final String successfulShards;
    @Nullable
    private final String failedShards;
    @Nullable
    private final String totalShards;
    @Nullable
    private final String reason;
    public static final JsonpDeserializer<SnapshotsRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotsRecord::setupSnapshotsRecordDeserializer);

    private SnapshotsRecord(Builder builder) {
        this.id = builder.id;
        this.repository = builder.repository;
        this.status = builder.status;
        this.startEpoch = builder.startEpoch;
        this.startTime = builder.startTime;
        this.endEpoch = builder.endEpoch;
        this.endTime = builder.endTime;
        this.duration = builder.duration;
        this.indices = builder.indices;
        this.successfulShards = builder.successfulShards;
        this.failedShards = builder.failedShards;
        this.totalShards = builder.totalShards;
        this.reason = builder.reason;
    }

    public static SnapshotsRecord of(Function<Builder, ObjectBuilder<SnapshotsRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String repository() {
        return this.repository;
    }

    @Nullable
    public final String status() {
        return this.status;
    }

    @Nullable
    public final String startEpoch() {
        return this.startEpoch;
    }

    @Nullable
    public final String startTime() {
        return this.startTime;
    }

    @Nullable
    public final String endEpoch() {
        return this.endEpoch;
    }

    @Nullable
    public final String endTime() {
        return this.endTime;
    }

    @Nullable
    public final Time duration() {
        return this.duration;
    }

    @Nullable
    public final String indices() {
        return this.indices;
    }

    @Nullable
    public final String successfulShards() {
        return this.successfulShards;
    }

    @Nullable
    public final String failedShards() {
        return this.failedShards;
    }

    @Nullable
    public final String totalShards() {
        return this.totalShards;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.repository != null) {
            generator.writeKey("repository");
            generator.write(this.repository);
        }
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status);
        }
        if (this.startEpoch != null) {
            generator.writeKey("start_epoch");
            generator.write(this.startEpoch);
        }
        if (this.startTime != null) {
            generator.writeKey("start_time");
            generator.write(this.startTime);
        }
        if (this.endEpoch != null) {
            generator.writeKey("end_epoch");
            generator.write(this.endEpoch);
        }
        if (this.endTime != null) {
            generator.writeKey("end_time");
            generator.write(this.endTime);
        }
        if (this.duration != null) {
            generator.writeKey("duration");
            this.duration.serialize(generator, mapper);
        }
        if (this.indices != null) {
            generator.writeKey("indices");
            generator.write(this.indices);
        }
        if (this.successfulShards != null) {
            generator.writeKey("successful_shards");
            generator.write(this.successfulShards);
        }
        if (this.failedShards != null) {
            generator.writeKey("failed_shards");
            generator.write(this.failedShards);
        }
        if (this.totalShards != null) {
            generator.writeKey("total_shards");
            generator.write(this.totalShards);
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
    }

    protected static void setupSnapshotsRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", "snapshot");
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository", "re", "repo");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status", "s");
        op.add(Builder::startEpoch, JsonpDeserializer.stringDeserializer(), "start_epoch", "ste", "startEpoch");
        op.add(Builder::startTime, JsonpDeserializer.stringDeserializer(), "start_time", "sti", "startTime");
        op.add(Builder::endEpoch, JsonpDeserializer.stringDeserializer(), "end_epoch", "ete", "endEpoch");
        op.add(Builder::endTime, JsonpDeserializer.stringDeserializer(), "end_time", "eti", "endTime");
        op.add(Builder::duration, Time._DESERIALIZER, "duration", "dur");
        op.add(Builder::indices, JsonpDeserializer.stringDeserializer(), "indices", "i");
        op.add(Builder::successfulShards, JsonpDeserializer.stringDeserializer(), "successful_shards", "ss");
        op.add(Builder::failedShards, JsonpDeserializer.stringDeserializer(), "failed_shards", "fs");
        op.add(Builder::totalShards, JsonpDeserializer.stringDeserializer(), "total_shards", "ts");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", "r");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotsRecord> {
        @Nullable
        private String id;
        @Nullable
        private String repository;
        @Nullable
        private String status;
        @Nullable
        private String startEpoch;
        @Nullable
        private String startTime;
        @Nullable
        private String endEpoch;
        @Nullable
        private String endTime;
        @Nullable
        private Time duration;
        @Nullable
        private String indices;
        @Nullable
        private String successfulShards;
        @Nullable
        private String failedShards;
        @Nullable
        private String totalShards;
        @Nullable
        private String reason;

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder repository(@Nullable String value) {
            this.repository = value;
            return this;
        }

        public final Builder status(@Nullable String value) {
            this.status = value;
            return this;
        }

        public final Builder startEpoch(@Nullable String value) {
            this.startEpoch = value;
            return this;
        }

        public final Builder startTime(@Nullable String value) {
            this.startTime = value;
            return this;
        }

        public final Builder endEpoch(@Nullable String value) {
            this.endEpoch = value;
            return this;
        }

        public final Builder endTime(@Nullable String value) {
            this.endTime = value;
            return this;
        }

        public final Builder duration(@Nullable Time value) {
            this.duration = value;
            return this;
        }

        public final Builder duration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.duration(fn.apply(new Time.Builder()).build());
        }

        public final Builder indices(@Nullable String value) {
            this.indices = value;
            return this;
        }

        public final Builder successfulShards(@Nullable String value) {
            this.successfulShards = value;
            return this;
        }

        public final Builder failedShards(@Nullable String value) {
            this.failedShards = value;
            return this;
        }

        public final Builder totalShards(@Nullable String value) {
            this.totalShards = value;
            return this;
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotsRecord build() {
            this._checkSingleUse();
            return new SnapshotsRecord(this);
        }
    }
}

