/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeStatistics
implements JsonpSerializable {
    private final List<ErrorCause> failures;
    private final int total;
    private final int successful;
    private final int failed;
    public static final JsonpDeserializer<NodeStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeStatistics::setupNodeStatisticsDeserializer);

    private NodeStatistics(Builder builder) {
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.successful = ApiTypeHelper.requireNonNull(builder.successful, this, "successful");
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, this, "failed");
    }

    public static NodeStatistics of(Function<Builder, ObjectBuilder<NodeStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ErrorCause> failures() {
        return this.failures;
    }

    public final int total() {
        return this.total;
    }

    public final int successful() {
        return this.successful;
    }

    public final int failed() {
        return this.failed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (ErrorCause item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("successful");
        generator.write(this.successful);
        generator.writeKey("failed");
        generator.write(this.failed);
    }

    protected static void setupNodeStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "failures");
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::successful, JsonpDeserializer.integerDeserializer(), "successful");
        op.add(Builder::failed, JsonpDeserializer.integerDeserializer(), "failed");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeStatistics> {
        @Nullable
        private List<ErrorCause> failures;
        private Integer total;
        private Integer successful;
        private Integer failed;

        public final Builder failures(List<ErrorCause> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(ErrorCause value, ErrorCause ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder failures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.failures(fn.apply(new ErrorCause.Builder()).build(), new ErrorCause[0]);
        }

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder successful(int value) {
            this.successful = value;
            return this;
        }

        public final Builder failed(int value) {
            this.failed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeStatistics build() {
            this._checkSingleUse();
            return new NodeStatistics(this);
        }
    }
}

