/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.TextMatcherEditor;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Text;

public class TextFilterList
extends TransformedList {
    private TextMatcherEditor textMatcherEditor;
    private Text filterEdit;
    private FilterModifyListener filterModifyListener = null;
    private FilterSelectionListener filterSelectionListener = new FilterSelectionListener();

    public TextFilterList(EventList source) {
        this(source, (Text)null, (TextFilterator)null);
    }

    public TextFilterList(EventList source, Text filterEdit) {
        this(source, filterEdit, (TextFilterator)null);
    }

    public TextFilterList(EventList source, String[] propertyNames) {
        this(source, null, GlazedLists.textFilterator(propertyNames));
    }

    public TextFilterList(EventList source, Text filterEdit, String[] propertyNames) {
        this(source, filterEdit, GlazedLists.textFilterator(propertyNames));
    }

    public TextFilterList(EventList source, Text filterEdit, TextFilterator filterator) {
        super(new FilterList(source));
        this.textMatcherEditor = new TextMatcherEditor(filterator);
        ((FilterList)this.source).setMatcherEditor(this.textMatcherEditor);
        if (filterEdit != null) {
            this.setFilterEdit(filterEdit);
        }
        this.source.addListEventListener(this);
    }

    public Text getFilterEdit() {
        return this.filterEdit;
    }

    public void setFilterEdit(Text filterEdit) {
        boolean live = true;
        if (this.filterEdit != null) {
            this.filterEdit.removeSelectionListener((SelectionListener)this.filterSelectionListener);
            live = this.filterModifyListener != null;
            this.setLive(false);
        }
        this.filterEdit = filterEdit;
        filterEdit.addSelectionListener((SelectionListener)this.filterSelectionListener);
        this.setLive(live);
        this.reFilter();
    }

    public void setLive(boolean live) {
        if (live) {
            if (this.filterModifyListener == null) {
                this.filterModifyListener = new FilterModifyListener();
                this.filterEdit.addModifyListener((ModifyListener)this.filterModifyListener);
            }
        } else if (this.filterModifyListener != null) {
            this.filterEdit.removeModifyListener((ModifyListener)this.filterModifyListener);
            this.filterModifyListener = null;
        }
    }

    public SelectionListener getFilterSelectionListener() {
        return this.filterSelectionListener;
    }

    private void reFilter() {
        this.textMatcherEditor.setFilterText(this.filterEdit.getText().split("[ \t]"));
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    protected boolean isWritable() {
        return true;
    }

    public void dispose() {
        FilterList filteredSource = (FilterList)this.source;
        super.dispose();
        filteredSource.dispose();
    }

    private class FilterSelectionListener
    implements SelectionListener {
        private FilterSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TextFilterList.this.reFilter();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TextFilterList.this.reFilter();
        }
    }

    class FilterModifyListener
    implements ModifyListener {
        FilterModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            TextFilterList.this.reFilter();
        }
    }
}

