/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.impl.SortIconFactory;
import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TableComparatorChooser
extends AbstractTableComparatorChooser {
    private final SortArrowHeaderRenderer sortArrowHeaderRenderer;
    private final Listener listener = new Listener();
    private JTable table = null;
    private ActionListener sortListener = null;
    private static Icon[] icons = SortIconFactory.loadIcons();

    public TableComparatorChooser(JTable table, SortedList sortedList, boolean multipleColumnSort) {
        super(sortedList, ((EventTableModel)table.getModel()).getTableFormat(), multipleColumnSort);
        this.table = table;
        this.sortArrowHeaderRenderer = new SortArrowHeaderRenderer();
        table.getTableHeader().setDefaultRenderer(this.sortArrowHeaderRenderer);
        table.setColumnSelectionAllowed(false);
        table.getTableHeader().addMouseListener(this.listener);
        table.getModel().addTableModelListener(this.listener);
    }

    public void addSortActionListener(ActionListener sortActionListener) {
        this.sortListener = AWTEventMulticaster.add(this.sortListener, sortActionListener);
    }

    public void removeSortActionListener(ActionListener sortActionListener) {
        this.sortListener = AWTEventMulticaster.remove(this.sortListener, sortActionListener);
    }

    protected void redetectComparator(Comparator currentComparator) {
        super.redetectComparator(currentComparator);
        this.table.getTableHeader().revalidate();
        this.table.getTableHeader().repaint();
    }

    protected final void rebuildComparator() {
        super.rebuildComparator();
        this.table.getTableHeader().revalidate();
        this.table.getTableHeader().repaint();
        if (this.sortListener != null) {
            this.sortListener.actionPerformed(new ActionEvent(this, 0, "sort"));
        }
    }

    protected final int getSortingStyle(int column) {
        return super.getSortingStyle(this.table.convertColumnIndexToModel(column));
    }

    protected boolean isSortingMouseEvent(MouseEvent e) {
        return e.getButton() == 1;
    }

    public void dispose() {
        super.dispose();
        if (this.table.getTableHeader().getDefaultRenderer() == this.sortArrowHeaderRenderer) {
            this.table.getTableHeader().setDefaultRenderer(this.sortArrowHeaderRenderer.getDelegateRenderer());
        }
        this.table.getTableHeader().removeMouseListener(this.listener);
        this.table.getModel().removeTableModelListener(this.listener);
        this.table = null;
    }

    public static void setIconPath(String path) {
        icons = SortIconFactory.loadIcons(path);
    }

    class SortArrowHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegateRenderer;
        private boolean iconInjection = false;

        public SortArrowHeaderRenderer() {
            this.delegateRenderer = TableComparatorChooser.this.table.getTableHeader().getDefaultRenderer();
            this.iconInjection = this.delegateRenderer instanceof DefaultTableCellRenderer;
        }

        public TableCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.iconInjection) {
                DefaultTableCellRenderer jLabelRenderer = (DefaultTableCellRenderer)this.delegateRenderer;
                Icon iconToUse = icons[TableComparatorChooser.this.getSortingStyle(column)];
                jLabelRenderer.setIcon(iconToUse);
                jLabelRenderer.setHorizontalTextPosition(10);
                return this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class Listener
    extends MouseAdapter
    implements TableModelListener {
        private Listener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (!TableComparatorChooser.this.isSortingMouseEvent(e)) {
                return;
            }
            TableColumnModel columnModel = TableComparatorChooser.this.table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = TableComparatorChooser.this.table.convertColumnIndexToModel(viewColumn);
            int clicks = e.getClickCount();
            if (clicks >= 1 && column != -1) {
                TableComparatorChooser.this.columnClicked(column, clicks);
            }
        }

        public void tableChanged(TableModelEvent event) {
            Comparator currentComparator;
            if (event.getFirstRow() == -1 && event.getColumn() == -1) {
                TableComparatorChooser.this.rebuildColumns();
            }
            if ((currentComparator = TableComparatorChooser.this.sortedList.getComparator()) != TableComparatorChooser.this.sortedListComparator) {
                TableComparatorChooser.this.redetectComparator(currentComparator);
            }
        }
    }
}

