/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.ListSelection;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class EventSelectionModel
implements ListSelectionModel {
    private ListSelection listSelection;
    private TransformedList swingSource;
    private boolean enabled = true;
    private List listeners = new ArrayList();
    private boolean valueIsAdjusting = false;
    private int fullChangeStart = -1;
    private int fullChangeFinish = -1;

    public EventSelectionModel(EventList source) {
        this.swingSource = GlazedListsSwing.swingThreadProxyList(source);
        this.listSelection = new ListSelection(this.swingSource);
        this.listSelection.addSelectionListener(new SwingSelectionListener());
    }

    public EventList getEventList() {
        return this.getSelected();
    }

    public EventList getSelected() {
        return this.listSelection.getSelected();
    }

    public EventList getDeselected() {
        return this.listSelection.getDeselected();
    }

    public ListSelectionModel getListSelectionModel() {
        return this;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    private void fireSelectionChanged(int changeStart, int changeFinish) {
        if (this.valueIsAdjusting) {
            if (this.fullChangeStart == -1 || changeStart < this.fullChangeStart) {
                this.fullChangeStart = changeStart;
            }
            if (this.fullChangeFinish == -1 || changeFinish > this.fullChangeFinish) {
                this.fullChangeFinish = changeFinish;
            }
        }
        ListSelectionEvent event = new ListSelectionEvent(this, changeStart, changeFinish, this.valueIsAdjusting);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ListSelectionListener listener = (ListSelectionListener)i.next();
            listener.valueChanged(event);
        }
    }

    public void invertSelection() {
        this.listSelection.invertSelection();
    }

    public void setSelectionInterval(int index0, int index1) {
        if (!this.enabled) {
            return;
        }
        this.listSelection.setSelection(index0, index1);
    }

    public void addSelectionInterval(int index0, int index1) {
        if (!this.enabled) {
            return;
        }
        this.listSelection.select(index0, index1);
    }

    public void removeSelectionInterval(int index0, int index1) {
        if (!this.enabled) {
            return;
        }
        if (index0 == 0 && index1 == 0 && this.swingSource.isEmpty()) {
            return;
        }
        this.listSelection.deselect(index0, index1);
    }

    public boolean isSelectedIndex(int index) {
        return this.listSelection.isSelected(index);
    }

    public int getAnchorSelectionIndex() {
        return this.listSelection.getAnchorSelectionIndex();
    }

    public void setAnchorSelectionIndex(int anchorSelectionIndex) {
        if (!this.enabled) {
            return;
        }
        this.listSelection.setAnchorSelectionIndex(anchorSelectionIndex);
    }

    public int getLeadSelectionIndex() {
        return this.listSelection.getLeadSelectionIndex();
    }

    public void setLeadSelectionIndex(int leadSelectionIndex) {
        if (!this.enabled) {
            return;
        }
        this.listSelection.setLeadSelectionIndex(leadSelectionIndex);
    }

    public int getMinSelectionIndex() {
        return this.listSelection.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.listSelection.getMaxSelectionIndex();
    }

    public void clearSelection() {
        if (!this.enabled) {
            return;
        }
        this.listSelection.deselectAll();
    }

    public boolean isSelectionEmpty() {
        return this.listSelection.getSelected().size() == 0;
    }

    public void insertIndexInterval(int index, int length, boolean before) {
    }

    public void removeIndexInterval(int index0, int index1) {
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
        if (!valueIsAdjusting && this.fullChangeStart != -1 && this.fullChangeFinish != -1) {
            this.fireSelectionChanged(this.fullChangeStart, this.fullChangeFinish);
            this.fullChangeStart = -1;
            this.fullChangeFinish = -1;
        }
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setSelectionMode(int selectionMode) {
        this.listSelection.setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.listSelection.getSelectionMode();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        this.listSelection.dispose();
    }

    private class SwingSelectionListener
    implements ListSelection.Listener {
        private SwingSelectionListener() {
        }

        public void selectionChanged(int changeStart, int changeEnd) {
            EventSelectionModel.this.fireSelectionChanged(changeStart, changeEnd);
        }
    }
}

