/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.Matcher;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ThreadedMatcherEditor
extends AbstractMatcherEditor {
    private final MatcherEditor source;
    private final List matcherEventQueue = Collections.synchronizedList(new LinkedList());
    private MatcherEditor.Listener queuingMatcherEditorListener = new QueuingMatcherEditorListener();
    private boolean isDrainingQueue = false;
    private Runnable drainMatcherEventQueueRunnable = new DrainMatcherEventQueueRunnable();

    public ThreadedMatcherEditor(MatcherEditor source) {
        if (source == null) {
            throw new NullPointerException("source may not be null");
        }
        this.source = source;
        this.source.addMatcherEditorListener(this.queuingMatcherEditorListener);
    }

    public Matcher getMatcher() {
        return this.source.getMatcher();
    }

    protected MatcherEditor.Event coalesceMatcherEvents(MatcherEditor.Event[] matcherEvents) {
        boolean changeType = false;
        MatcherEditor.Event lastMatcherEvent = matcherEvents[matcherEvents.length - 1];
        int lastMatcherEventType = lastMatcherEvent.getType();
        if (lastMatcherEventType != 0 && lastMatcherEventType != 1) {
            boolean constrained = false;
            boolean relaxed = false;
            block7: for (int i = 0; i < matcherEvents.length; ++i) {
                switch (matcherEvents[i].getType()) {
                    case 0: {
                        relaxed = true;
                        continue block7;
                    }
                    case 1: {
                        constrained = true;
                        continue block7;
                    }
                    case 3: {
                        relaxed = true;
                        continue block7;
                    }
                    case 2: {
                        constrained = true;
                        continue block7;
                    }
                    case 4: {
                        relaxed = true;
                        constrained = true;
                    }
                }
            }
            changeType = constrained && relaxed;
        }
        return new MatcherEditor.Event(this, changeType ? 4 : lastMatcherEventType, lastMatcherEvent.getMatcher());
    }

    protected void executeMatcherEventQueueRunnable(Runnable runnable) {
        new Thread(runnable, "MatcherQueueThread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainQueue() {
        List list = this.matcherEventQueue;
        synchronized (list) {
            if (!this.isDrainingQueue) {
                this.executeMatcherEventQueueRunnable(this.drainMatcherEventQueueRunnable);
                this.isDrainingQueue = true;
            }
        }
    }

    private class DrainMatcherEventQueueRunnable
    implements Runnable {
        private DrainMatcherEventQueueRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block7: while (true) {
                    List list = ThreadedMatcherEditor.this.matcherEventQueue;
                    synchronized (list) {
                        if (ThreadedMatcherEditor.this.matcherEventQueue.isEmpty()) {
                            return;
                        }
                    }
                    MatcherEditor.Event[] matcherEvents = ThreadedMatcherEditor.this.matcherEventQueue.toArray(new MatcherEditor.Event[ThreadedMatcherEditor.this.matcherEventQueue.size()]);
                    MatcherEditor.Event coalescedMatcherEvent = ThreadedMatcherEditor.this.coalesceMatcherEvents(matcherEvents);
                    ThreadedMatcherEditor.this.fireChangedMatcher(coalescedMatcherEvent);
                    int i = 0;
                    while (true) {
                        if (i >= matcherEvents.length) continue block7;
                        ThreadedMatcherEditor.this.matcherEventQueue.remove(0);
                        ++i;
                    }
                    break;
                }
            }
            finally {
                ThreadedMatcherEditor.this.isDrainingQueue = false;
            }
        }
    }

    private class QueuingMatcherEditorListener
    implements MatcherEditor.Listener {
        private QueuingMatcherEditorListener() {
        }

        public void changedMatcher(MatcherEditor.Event matcherEvent) {
            ThreadedMatcherEditor.this.matcherEventQueue.add(matcherEvent);
            ThreadedMatcherEditor.this.drainQueue();
        }
    }
}

