/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.List;

public abstract class ThreadProxyEventList
extends TransformedList {
    private List localCache = new ArrayList();
    private UpdateRunner updateRunner = new UpdateRunner();
    private boolean scheduled = false;
    public volatile boolean debug = false;

    public ThreadProxyEventList(EventList source) {
        super(source);
        this.localCache.addAll(source);
        this.addListEventListener(this.updateRunner);
        source.addListEventListener(this);
    }

    public final void listChanged(ListEvent listChanges) {
        if (!this.scheduled) {
            this.updates.beginEvent(true);
        }
        this.updates.forwardEvent(listChanges);
        if (!this.scheduled) {
            this.scheduled = true;
            this.schedule(this.updateRunner);
        }
    }

    protected abstract void schedule(Runnable var1);

    public final int size() {
        return this.localCache.size();
    }

    public final Object get(int index) {
        return this.localCache.get(index);
    }

    protected final boolean isWritable() {
        return true;
    }

    private class UpdateRunner
    implements Runnable,
    ListEventListener {
        private UpdateRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadProxyEventList.this.getReadWriteLock().writeLock().lock();
            try {
                ThreadProxyEventList.this.updates.commitEvent();
                ThreadProxyEventList.this.scheduled = false;
            }
            finally {
                ThreadProxyEventList.this.getReadWriteLock().writeLock().unlock();
            }
        }

        public void listChanged(ListEvent listChanges) {
            while (listChanges.next()) {
                int sourceIndex = listChanges.getIndex();
                int changeType = listChanges.getType();
                if (changeType == 0) {
                    ThreadProxyEventList.this.localCache.remove(sourceIndex);
                    continue;
                }
                if (changeType == 2) {
                    ThreadProxyEventList.this.localCache.add(sourceIndex, ThreadProxyEventList.this.source.get(sourceIndex));
                    continue;
                }
                if (changeType != 1) continue;
                ThreadProxyEventList.this.localCache.set(sourceIndex, ThreadProxyEventList.this.source.get(sourceIndex));
            }
        }
    }
}

