/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.TextSearchStrategy;

public class SingleCharacterCaseInsensitiveTextSearchStrategy
implements TextSearchStrategy {
    private char subtextChar;
    private boolean subtextInitialized = false;

    public void setSubtext(String subtext) {
        if (subtext == null) {
            throw new IllegalArgumentException("subtext may not be null");
        }
        if (subtext.length() != 1) {
            throw new IllegalArgumentException("subtext (" + subtext + ") must contain a single character");
        }
        this.subtextChar = Character.toUpperCase(subtext.charAt(0));
        this.subtextInitialized = true;
    }

    public int indexOf(String text) {
        if (!this.subtextInitialized) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        int textLength = text.length();
        for (int c = 0; c < textLength; ++c) {
            if (Character.toUpperCase(text.charAt(c)) != this.subtextChar) continue;
            return c;
        }
        return -1;
    }
}

