/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.IndexedTree;
import java.util.Comparator;

public final class IndexedTreeNode {
    IndexedTreeNode parent;
    IndexedTreeNode left = null;
    IndexedTreeNode right = null;
    int leftSize = 0;
    int rightSize = 0;
    private int height = 0;
    private Object value;
    static final /* synthetic */ boolean $assertionsDisabled;

    IndexedTreeNode(IndexedTreeNode parent) {
        this.parent = parent;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    IndexedTreeNode getNodeWithIndex(int index) {
        if (index < this.leftSize) {
            return this.left.getNodeWithIndex(index);
        }
        if (index > this.leftSize) {
            return this.right.getNodeWithIndex(index - (this.leftSize + 1));
        }
        return this;
    }

    IndexedTreeNode getNodeByValue(Comparator comparator, Object searchValue) {
        int sortSide = comparator.compare(searchValue, this.value);
        if (sortSide < 0) {
            if (this.left == null) {
                return null;
            }
            return this.left.getNodeByValue(comparator, searchValue);
        }
        if (sortSide > 0) {
            if (this.right == null) {
                return null;
            }
            return this.right.getNodeByValue(comparator, searchValue);
        }
        return this;
    }

    int size() {
        return this.leftSize + 1 + this.rightSize;
    }

    int height() {
        return this.height;
    }

    IndexedTreeNode getLargestChildNode() {
        if (this.rightSize > 0) {
            return this.right.getLargestChildNode();
        }
        return this;
    }

    IndexedTreeNode getSmallestChildNode() {
        if (this.leftSize > 0) {
            return this.left.getSmallestChildNode();
        }
        return this;
    }

    public int getIndex() {
        return this.getIndex(null);
    }

    private int getIndex(IndexedTreeNode child) {
        if (child == this.left) {
            if (this.parent != null) {
                return this.parent.getIndex(this);
            }
            return 0;
        }
        if (child == null) {
            if (this.parent != null) {
                return this.parent.getIndex(this) + this.leftSize;
            }
            return this.leftSize;
        }
        if (child == this.right) {
            if (this.parent != null) {
                return this.parent.getIndex(this) + this.leftSize + 1;
            }
            return this.leftSize + 1;
        }
        throw new IndexOutOfBoundsException(this + " cannot get the index of a subtree that does not exist on this node!");
    }

    IndexedTreeNode insert(IndexedTree host, Object inserted) {
        if (this.value == null) {
            if (!($assertionsDisabled || this.leftSize == 0 && this.rightSize == 0)) {
                throw new AssertionError();
            }
            this.value = inserted;
            this.ensureAVL(host);
            return this;
        }
        if (host.getComparator().compare(inserted, this.value) < 0) {
            if (this.left == null) {
                this.left = new IndexedTreeNode(this);
            }
            ++this.leftSize;
            return this.left.insert(host, inserted);
        }
        if (this.right == null) {
            this.right = new IndexedTreeNode(this);
        }
        ++this.rightSize;
        return this.right.insert(host, inserted);
    }

    IndexedTreeNode insert(IndexedTree host, int index, Object inserted) {
        if (index == 0 && this.value == null) {
            if (!($assertionsDisabled || this.leftSize == 0 && this.rightSize == 0)) {
                throw new AssertionError();
            }
            this.value = inserted;
            this.ensureAVL(host);
            return this;
        }
        if (index <= this.leftSize) {
            if (this.left == null) {
                this.left = new IndexedTreeNode(this);
            }
            ++this.leftSize;
            return this.left.insert(host, index, inserted);
        }
        if (this.right == null) {
            this.right = new IndexedTreeNode(this);
        }
        ++this.rightSize;
        return this.right.insert(host, index - this.leftSize - 1, inserted);
    }

    IndexedTreeNode removeNode(IndexedTree host, int index) {
        if (index < this.leftSize) {
            --this.leftSize;
            return this.left.removeNode(host, index);
        }
        if (index > this.leftSize) {
            --this.rightSize;
            return this.right.removeNode(host, index - (this.leftSize + 1));
        }
        if (this.leftSize == 0 && this.rightSize == 0) {
            if (this.parent != null) {
                this.parent.replaceChildNode(this, null);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(null);
            }
        } else if (this.leftSize > 0 && this.rightSize == 0) {
            this.left.parent = this.parent;
            if (this.parent != null) {
                this.parent.replaceChildNode(this, this.left);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(this.left);
            }
        } else if (this.leftSize == 0 && this.rightSize > 0) {
            this.right.parent = this.parent;
            if (this.parent != null) {
                this.parent.replaceChildNode(this, this.right);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(this.right);
            }
        } else {
            IndexedTreeNode replacement = null;
            if (this.leftSize > this.rightSize) {
                --this.leftSize;
                replacement = this.left.pruneLargestChild(host);
            } else {
                --this.rightSize;
                replacement = this.right.pruneSmallestChild(host);
            }
            replacement.left = this.left;
            replacement.leftSize = this.leftSize;
            if (this.left != null) {
                this.left.parent = replacement;
            }
            replacement.right = this.right;
            replacement.rightSize = this.rightSize;
            if (this.right != null) {
                this.right.parent = replacement;
            }
            replacement.height = this.height;
            replacement.parent = this.parent;
            if (this.parent != null) {
                this.parent.replaceChildNode(this, replacement);
            } else {
                host.setRootNode(replacement);
            }
        }
        this.clearNodeValues();
        return this;
    }

    IndexedTreeNode pruneSmallestChild(IndexedTree host) {
        if (this.leftSize > 0) {
            --this.leftSize;
            return this.left.pruneSmallestChild(host);
        }
        IndexedTreeNode replacement = null;
        if (this.rightSize != 0) {
            replacement = this.right;
            this.right.parent = this.parent;
        }
        if (this.parent != null) {
            this.parent.replaceChildNode(this, replacement);
            this.parent.ensureAVL(host);
        } else {
            host.setRootNode(replacement);
        }
        this.clearNodeValues();
        return this;
    }

    IndexedTreeNode pruneLargestChild(IndexedTree host) {
        if (this.rightSize > 0) {
            --this.rightSize;
            return this.right.pruneLargestChild(host);
        }
        IndexedTreeNode replacement = null;
        if (this.leftSize != 0) {
            replacement = this.left;
            this.left.parent = this.parent;
        }
        if (this.parent != null) {
            this.parent.replaceChildNode(this, replacement);
            this.parent.ensureAVL(host);
        } else {
            host.setRootNode(replacement);
        }
        this.clearNodeValues();
        return this;
    }

    public void removeFromTree(IndexedTree host) {
        if (!$assertionsDisabled && this.value == null) {
            throw new AssertionError();
        }
        if (this.leftSize == 0 && this.rightSize == 0) {
            if (this.parent != null) {
                this.parent.notifyChildNodeRemoved(this);
                this.parent.replaceChildNode(this, null);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(null);
            }
        } else if (this.leftSize > 0 && this.rightSize == 0) {
            this.left.parent = this.parent;
            if (this.parent != null) {
                this.parent.notifyChildNodeRemoved(this);
                this.parent.replaceChildNode(this, this.left);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(this.left);
            }
        } else if (this.leftSize == 0 && this.rightSize > 0) {
            this.right.parent = this.parent;
            if (this.parent != null) {
                this.parent.notifyChildNodeRemoved(this);
                this.parent.replaceChildNode(this, this.right);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(this.right);
            }
        } else {
            IndexedTreeNode middle = null;
            middle = this.leftSize > this.rightSize ? this.left.getLargestChildNode() : this.right.getSmallestChildNode();
            middle.removeFromTree(host);
            if (!($assertionsDisabled || middle.leftSize == 0 && middle.rightSize == 0)) {
                throw new AssertionError();
            }
            middle.left = this.left;
            middle.leftSize = this.leftSize;
            if (this.left != null) {
                this.left.parent = middle;
            }
            middle.right = this.right;
            middle.rightSize = this.rightSize;
            if (this.right != null) {
                this.right.parent = middle;
            }
            middle.height = this.height;
            middle.parent = this.parent;
            if (this.parent != null) {
                this.parent.replaceChildNode(this, middle);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(middle);
            }
        }
        this.clearNodeValues();
    }

    private void clearNodeValues() {
        this.parent = null;
        this.left = null;
        this.leftSize = 0;
        this.right = null;
        this.rightSize = 0;
    }

    private void notifyChildNodeRemoved(IndexedTreeNode subtree) {
        if (subtree == this.left) {
            --this.leftSize;
        } else if (subtree == this.right) {
            --this.rightSize;
        } else {
            throw new IllegalArgumentException(this + " cannot remove a subtree that does not exist on this node!");
        }
        if (this.parent != null) {
            this.parent.notifyChildNodeRemoved(this);
        }
    }

    private void replaceChildNode(IndexedTreeNode original, IndexedTreeNode replacement) {
        if (original == this.left) {
            this.left = replacement;
        } else if (original == this.right) {
            this.right = replacement;
        } else {
            throw new IllegalArgumentException(this + " cannot replace a non-existant child");
        }
    }

    void validate(IndexedTree host) {
        if (this.left != null) {
            this.left.validate(host);
        }
        if (this.right != null) {
            this.right.validate(host);
        }
        if (host.getComparator() != null) {
            if (this.leftSize > 0 && host.getComparator().compare(this.left.value, this.value) > 0) {
                throw new IllegalStateException("" + this + "left larger than middle");
            }
            if (this.rightSize > 0 && host.getComparator().compare(this.value, this.right.value) > 0) {
                throw new IllegalStateException("" + this + " middle larger than right");
            }
        }
        if (this.left == null && this.leftSize != 0 || this.left != null && this.leftSize != this.left.size()) {
            throw new IllegalStateException("Cached leftSize " + this.leftSize + " != reported left.size() " + this.left.size());
        }
        if (this.right == null && this.rightSize != 0 || this.right != null && this.rightSize != this.right.size()) {
            throw new IllegalStateException("Cached rightSize " + this.rightSize + " != reported right.size() " + this.right.size());
        }
    }

    private void ensureAVL(IndexedTree host) {
        int oldHeight = this.height;
        this.recalculateHeight();
        this.avlRotate(host);
        if (this.height != oldHeight && this.parent != null) {
            this.parent.ensureAVL(host);
        }
    }

    private void recalculateHeight() {
        int leftHeight = this.left == null ? 0 : this.left.height;
        int rightHeight = this.right == null ? 0 : this.right.height;
        this.height = 1 + Math.max(leftHeight, rightHeight);
    }

    private void avlRotate(IndexedTree host) {
        int rightHeight;
        int leftHeight = this.left != null ? this.left.height : 0;
        int n = rightHeight = this.right != null ? this.right.height : 0;
        if (leftHeight - rightHeight >= 2) {
            int leftRightHeight;
            int leftLeftHeight = this.left.left != null ? this.left.left.height : 0;
            int n2 = leftRightHeight = this.left.right != null ? this.left.right.height : 0;
            if (leftRightHeight > leftLeftHeight) {
                this.left.rotateRight(host);
            }
            this.rotateLeft(host);
        } else if (rightHeight - leftHeight >= 2) {
            int rightRightHeight;
            int rightLeftHeight = this.right.left != null ? this.right.left.height : 0;
            int n3 = rightRightHeight = this.right.right != null ? this.right.right.height : 0;
            if (rightLeftHeight > rightRightHeight) {
                this.right.rotateLeft(host);
            }
            this.rotateRight(host);
        }
    }

    private void rotateLeft(IndexedTree host) {
        IndexedTreeNode replacement = this.left;
        this.left = replacement.right;
        this.leftSize = replacement.rightSize;
        if (replacement.right != null) {
            replacement.right.parent = this;
        }
        replacement.right = this;
        replacement.rightSize = this.size();
        if (this.parent != null) {
            this.parent.replaceChildNode(this, replacement);
        } else {
            host.setRootNode(replacement);
        }
        replacement.parent = this.parent;
        this.parent = replacement;
        this.recalculateHeight();
        replacement.height = 0;
    }

    private void rotateRight(IndexedTree host) {
        IndexedTreeNode replacement = this.right;
        this.right = replacement.left;
        this.rightSize = replacement.leftSize;
        if (replacement.left != null) {
            replacement.left.parent = this;
        }
        replacement.left = this;
        replacement.leftSize = this.size();
        if (this.parent != null) {
            this.parent.replaceChildNode(this, replacement);
        } else {
            host.setRootNode(replacement);
        }
        replacement.parent = this.parent;
        this.parent = replacement;
        this.recalculateHeight();
        replacement.height = 0;
    }

    boolean contains(Comparator comparator, Object object) {
        int sortSide = comparator.compare(object, this.value);
        if (sortSide < 0) {
            if (this.left == null) {
                return false;
            }
            return this.left.contains(comparator, object);
        }
        if (sortSide == 0) {
            return true;
        }
        if (this.right == null) {
            return false;
        }
        return this.right.contains(comparator, object);
    }

    int indexOf(Comparator comparator, Object object, boolean simulate) {
        int sortSide = comparator.compare(object, this.value);
        if (sortSide < 0) {
            if (this.left == null) {
                if (simulate) {
                    return this.getIndex();
                }
                return -1;
            }
            return this.left.indexOf(comparator, object, simulate);
        }
        if (sortSide == 0) {
            return this.findLastNode(comparator, this, object, true);
        }
        if (this.right == null) {
            if (simulate) {
                return this.getIndex() + 1;
            }
            return -1;
        }
        return this.right.indexOf(comparator, object, simulate);
    }

    int lastIndexOf(Comparator comparator, Object object) {
        int sortSide = comparator.compare(object, this.value);
        if (sortSide < 0) {
            if (this.left == null) {
                return -1;
            }
            return this.left.lastIndexOf(comparator, object);
        }
        if (sortSide == 0) {
            return this.findLastNode(comparator, this, object, false);
        }
        if (this.right == null) {
            return -1;
        }
        return this.right.lastIndexOf(comparator, object);
    }

    private int findLastNode(Comparator comparator, IndexedTreeNode parentNode, Object object, boolean goLeft) {
        IndexedTreeNode child = null;
        child = goLeft ? parentNode.left : parentNode.right;
        if (child == null) {
            return parentNode.getIndex();
        }
        if (comparator.compare(object, child.value) != 0) {
            int result = this.secondaryLastNodeSearch(comparator, child, object, !goLeft);
            if (result != -1) {
                return result;
            }
            return parentNode.getIndex();
        }
        return this.findLastNode(comparator, child, object, goLeft);
    }

    private int secondaryLastNodeSearch(Comparator comparator, IndexedTreeNode parentNode, Object object, boolean goLeft) {
        IndexedTreeNode child = null;
        child = goLeft ? parentNode.left : parentNode.right;
        if (child == null) {
            return -1;
        }
        if (comparator.compare(object, child.value) == 0) {
            return this.findLastNode(comparator, child, object, !goLeft);
        }
        return this.secondaryLastNodeSearch(comparator, child, object, goLeft);
    }

    public String toString() {
        String valueString = this.value.toString();
        if (this.left != null && this.right != null) {
            return "(" + this.left.toString() + " " + valueString + " " + this.right.toString() + ")";
        }
        if (this.left != null) {
            return "(" + this.left.toString() + " " + valueString + " .)";
        }
        if (this.right != null) {
            return "(. " + valueString + " " + this.right.toString() + ")";
        }
        if (this.value == null) {
            return ".";
        }
        return valueString;
    }

    static {
        $assertionsDisabled = !IndexedTreeNode.class.desiredAssertionStatus();
    }
}

