/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.IndexedTree;
import ca.odell.glazedlists.impl.adt.IndexedTreeNode;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class IndexedTreeIterator
implements ListIterator {
    private int currentIndex = 0;
    private IndexedTree host = null;
    private IndexedTreeNode currentNode = null;
    private boolean goingForward = true;

    public IndexedTreeIterator(IndexedTree host) {
        this(host, 0);
    }

    public IndexedTreeIterator(IndexedTree host, int index) {
        this.host = host;
        this.currentIndex = index - 1;
        this.currentNode = host.root == null ? null : (this.currentIndex > -1 ? host.getNode(this.currentIndex) : host.root.getSmallestChildNode());
    }

    public boolean hasNext() {
        return this.currentIndex < this.host.size() - 1;
    }

    public int nextIndex() {
        return this.currentIndex + 1;
    }

    public Object next() {
        if (this.currentNode == null || this.currentIndex >= this.host.size() - 1) {
            throw new NoSuchElementException();
        }
        if (this.currentIndex == -1) {
            this.currentIndex = 0;
            this.goingForward = true;
            return this.currentNode;
        }
        if (this.goingForward) {
            ++this.currentIndex;
            this.findNextNode();
            return this.currentNode;
        }
        this.goingForward = true;
        return this.currentNode;
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    public int previousIndex() {
        return this.currentIndex;
    }

    public Object previous() {
        if (this.currentNode == null || this.currentIndex < 0) {
            throw new NoSuchElementException();
        }
        if (this.currentIndex == 0) {
            this.currentIndex = -1;
            this.goingForward = false;
            return this.currentNode;
        }
        if (!this.goingForward) {
            --this.currentIndex;
            this.findPreviousNode();
            return this.currentNode;
        }
        this.goingForward = false;
        return this.currentNode;
    }

    public void remove() {
        if (this.currentNode == null || this.currentIndex == -1) {
            throw new NoSuchElementException();
        }
        if (this.host.size() == 1) {
            this.currentIndex = -1;
            this.currentNode = null;
        } else if (this.currentIndex == 0) {
            this.currentIndex = -1;
            IndexedTreeNode nodeToRemove = this.currentNode;
            this.findNextNode();
            nodeToRemove.removeFromTree(this.host);
        } else {
            --this.currentIndex;
            IndexedTreeNode nodeToRemove = this.currentNode;
            this.findPreviousNode();
            nodeToRemove.removeFromTree(this.host);
        }
    }

    public void add(Object value) {
        if (this.currentNode == null || this.currentIndex == -1) {
            this.host.addByNode(0, value);
        } else {
            this.currentNode.insert(this.host, 1, value);
            ++this.currentIndex;
            this.findNextNode();
        }
    }

    public void set(Object value) {
        if (this.currentNode == null || this.currentIndex == -1) {
            throw new NoSuchElementException();
        }
        this.currentNode.setValue(value);
    }

    private void findNextNode() {
        if (this.currentNode.right != null) {
            this.currentNode = this.currentNode.right;
            while (this.currentNode.left != null) {
                this.currentNode = this.currentNode.left;
            }
        } else if (this.currentNode.parent.left == this.currentNode) {
            this.currentNode = this.currentNode.parent;
        } else if (this.currentNode.parent.right == this.currentNode) {
            while (this.currentNode.parent.right == this.currentNode) {
                this.currentNode = this.currentNode.parent;
            }
            this.currentNode = this.currentNode.parent;
        } else {
            throw new IllegalStateException();
        }
    }

    private void findPreviousNode() {
        if (this.currentNode.left != null) {
            this.currentNode = this.currentNode.left;
            while (this.currentNode.right != null) {
                this.currentNode = this.currentNode.right;
            }
        } else if (this.currentNode.parent.right == this.currentNode) {
            this.currentNode = this.currentNode.parent;
        } else if (this.currentNode.parent.left == this.currentNode) {
            while (this.currentNode.parent.left == this.currentNode) {
                this.currentNode = this.currentNode.parent;
            }
            this.currentNode = this.currentNode.parent;
        } else {
            throw new IllegalStateException();
        }
    }
}

