/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class Diff {
    public static void replaceAll(EventList target, List source, boolean updates) {
        Diff.replaceAll(target, source, updates, new EqualsComparator());
    }

    public static void replaceAll(EventList target, List source, boolean updates, Comparator comparator) {
        ListDiffMatcher listDiffMatcher = new ListDiffMatcher(target, source, comparator);
        List editScript = Diff.shortestEditScript(listDiffMatcher);
        int targetIndex = 0;
        int sourceIndex = 0;
        Point previousPoint = null;
        Iterator i = editScript.iterator();
        while (i.hasNext()) {
            int deltaY;
            Point currentPoint = (Point)i.next();
            if (previousPoint == null) {
                previousPoint = currentPoint;
                continue;
            }
            int deltaX = currentPoint.getX() - previousPoint.getX();
            if (deltaX == (deltaY = currentPoint.getY() - previousPoint.getY())) {
                if (updates) {
                    for (int u = 0; u < deltaX; ++u) {
                        target.set(targetIndex + u, source.get(sourceIndex + u));
                    }
                }
                targetIndex += deltaX;
                sourceIndex += deltaY;
            } else if (deltaX == 1 && deltaY == 0) {
                target.remove(targetIndex);
            } else if (deltaX == 0 && deltaY == 1) {
                target.add(targetIndex, source.get(sourceIndex));
                ++sourceIndex;
                ++targetIndex;
            } else {
                throw new IllegalStateException();
            }
            previousPoint = currentPoint;
        }
    }

    private static List shortestEditScript(DiffMatcher input) {
        int N = input.getAlphaLength();
        int M = input.getBetaLength();
        Point maxPoint = new Point(N, M);
        int maxSteps = N + M;
        HashMap<Integer, Point> furthestReachingPoints = new HashMap<Integer, Point>();
        for (int D = 0; D <= maxSteps; ++D) {
            for (int k = -D; k <= D; k += 2) {
                Point belowLeft = (Point)furthestReachingPoints.get(new Integer(k - 1));
                Point aboveRight = (Point)furthestReachingPoints.get(new Integer(k + 1));
                Point point = furthestReachingPoints.isEmpty() ? new Point(0, 0) : (k == -D || k != D && belowLeft.getX() < aboveRight.getX() ? aboveRight.createDeltaPoint(0, 1) : belowLeft.createDeltaPoint(1, 0));
                while (point.isLessThan(maxPoint) && input.matchPair(point.getX(), point.getY())) {
                    point = point.incrementDiagonally();
                }
                furthestReachingPoints.put(new Integer(k), point);
                if (!point.isEqualToOrGreaterThan(maxPoint)) continue;
                return point.trail();
            }
        }
        throw new IllegalStateException();
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: LCS <alpha> <beta>");
            return;
        }
        String alpha = args[0];
        BasicEventList alphaList = new BasicEventList();
        for (int c = 0; c < alpha.length(); ++c) {
            alphaList.add(new Character(alpha.charAt(c)));
        }
        String beta = args[1];
        ArrayList<Character> betaList = new ArrayList<Character>();
        for (int c = 0; c < beta.length(); ++c) {
            betaList.add(new Character(beta.charAt(c)));
        }
        Diff.drawGrid(new ListDiffMatcher(alphaList, betaList, null));
        Diff.replaceAll(alphaList, betaList, false, null);
        System.out.println(alphaList);
    }

    public static void drawGrid(DiffMatcher diffMatcher) {
        int x;
        System.out.print("      ");
        for (x = 0; x < diffMatcher.getAlphaLength(); ++x) {
            System.out.print(x);
            if (x < 10) {
                System.out.print(" ");
            }
            if (x >= 100) continue;
            System.out.print(" ");
        }
        System.out.println("");
        System.out.print("      ");
        for (x = 0; x < diffMatcher.getAlphaLength(); ++x) {
            System.out.print(diffMatcher.alphaAt(x));
            System.out.print("  ");
        }
        System.out.println("");
        for (int y = 0; y < diffMatcher.getBetaLength(); ++y) {
            System.out.print(y);
            if (y < 10) {
                System.out.print(" ");
            }
            if (y < 100) {
                System.out.print(" ");
            }
            System.out.print(" ");
            System.out.print(diffMatcher.betaAt(y));
            System.out.print(" ");
            for (int x2 = 0; x2 < diffMatcher.getAlphaLength(); ++x2) {
                boolean match = diffMatcher.matchPair(x2, y);
                if (match) {
                    System.out.print("_\\|");
                    continue;
                }
                System.out.print("__|");
            }
            System.out.println("");
        }
    }

    private static class EqualsComparator
    implements Comparator {
        private EqualsComparator() {
        }

        public int compare(Object alpha, Object beta) {
            boolean equal = alpha == null ? beta == null : alpha.equals(beta);
            return equal ? 0 : 1;
        }
    }

    private static class ListDiffMatcher
    implements DiffMatcher {
        private List alpha;
        private List beta;
        private Comparator comparator;

        public ListDiffMatcher(List alpha, List beta, Comparator comparator) {
            this.alpha = alpha;
            this.beta = beta;
            this.comparator = comparator;
        }

        public int getAlphaLength() {
            return this.alpha.size();
        }

        public char alphaAt(int index) {
            return this.alpha.get(index).toString().charAt(0);
        }

        public char betaAt(int index) {
            return this.beta.get(index).toString().charAt(0);
        }

        public int getBetaLength() {
            return this.beta.size();
        }

        public boolean matchPair(int alphaIndex, int betaIndex) {
            return this.comparator.compare(this.alpha.get(alphaIndex), this.beta.get(betaIndex)) == 0;
        }
    }

    private static class StringDiffMatcher
    implements DiffMatcher {
        private String alpha;
        private String beta;

        public StringDiffMatcher(String alpha, String beta) {
            this.alpha = alpha;
            this.beta = beta;
        }

        public int getAlphaLength() {
            return this.alpha.length();
        }

        public char alphaAt(int index) {
            return this.alpha.charAt(index);
        }

        public char betaAt(int index) {
            return this.beta.charAt(index);
        }

        public int getBetaLength() {
            return this.beta.length();
        }

        public boolean matchPair(int alphaIndex, int betaIndex) {
            return this.alpha.charAt(alphaIndex) == this.beta.charAt(betaIndex);
        }
    }

    private static interface DiffMatcher {
        public int getAlphaLength();

        public int getBetaLength();

        public boolean matchPair(int var1, int var2);

        public char alphaAt(int var1);

        public char betaAt(int var1);
    }

    private static class Point {
        private int x = 0;
        private int y = 0;
        private Point predecessor = null;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Point createDeltaPoint(int deltaX, int deltaY) {
            Point result = new Point(this.x + deltaX, this.y + deltaY);
            result.predecessor = this;
            return result;
        }

        public Point incrementDiagonally() {
            int deltaY;
            int deltaX;
            Point result = this.createDeltaPoint(1, 1);
            if (this.predecessor != null && (deltaX = result.x - this.predecessor.x) == (deltaY = result.y - this.predecessor.y)) {
                result.predecessor = this.predecessor;
            }
            return result;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean isLessThan(Point other) {
            return this.x < other.x && this.y < other.y;
        }

        public boolean isEqualToOrGreaterThan(Point other) {
            return this.x >= other.x && this.y >= other.y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }

        public List trail() {
            ArrayList<Point> reverse = new ArrayList<Point>();
            Point current = this;
            while (current != null) {
                reverse.add(current);
                current = current.predecessor;
            }
            Collections.reverse(reverse);
            return reverse;
        }
    }
}

