/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser.swing;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;

abstract class StyledRenderer
implements TableCellRenderer {
    protected JTextPane rendered;
    protected DefaultStyledDocument styledDocument;
    private boolean controlHeight;

    public StyledRenderer(boolean controlHeight) {
        this.controlHeight = controlHeight;
        this.styledDocument = new DefaultStyledDocument();
        this.rendered = new JTextPane(this.styledDocument);
        this.rendered.setEnabled(false);
    }

    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.beforeWrite(this.styledDocument, table, value, isSelected, hasFocus, row, column);
        this.writeObject(this.styledDocument, table, value, isSelected, hasFocus, row, column);
        this.afterWrite(this.styledDocument, table, value, isSelected, hasFocus, row, column);
        return this.rendered;
    }

    public abstract void writeObject(DefaultStyledDocument var1, JTable var2, Object var3, boolean var4, boolean var5, int var6, int var7);

    protected void beforeWrite(DefaultStyledDocument doc, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.colorSelected(isSelected);
        int columnWidth = table.getColumnModel().getColumn(column).getWidth();
        Rectangle bounds = this.rendered.getBounds();
        bounds.width = columnWidth;
        bounds.height = 1000;
        this.rendered.setBounds(bounds);
        this.clear();
    }

    private void colorSelected(boolean isSelected) {
        if (isSelected) {
            this.rendered.setBackground(UIManager.getColor("Table.selectionBackground"));
        } else {
            this.rendered.setBackground(UIManager.getColor("Table.background"));
        }
    }

    protected void afterWrite(DefaultStyledDocument doc, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int requiredRowHeight = this.rendered.getPreferredSize().height;
        int currentRowHeight = table.getRowHeight(row);
        if (this.controlHeight && currentRowHeight != requiredRowHeight) {
            table.setRowHeight(row, requiredRowHeight);
        }
    }

    public static void append(DefaultStyledDocument targetDocument, String text, Style format) {
        try {
            int offset = targetDocument.getLength();
            targetDocument.insertString(offset, text, format);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void clear() {
        try {
            this.styledDocument.remove(0, this.styledDocument.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }
}

