/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser.swing;

import ca.odell.glazedlists.demo.issuebrowser.Description;
import ca.odell.glazedlists.demo.issuebrowser.swing.StyledRenderer;
import java.text.SimpleDateFormat;
import javax.swing.JTable;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class DescriptionRenderer
extends StyledRenderer {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy");
    private Style whoStyle = null;
    private Style plain = this.styledDocument.addStyle("plain", null);

    public DescriptionRenderer() {
        super(true);
        this.whoStyle = this.styledDocument.addStyle("boldItalicRed", null);
        StyleConstants.setBold(this.whoStyle, true);
        StyleConstants.setFontSize(this.whoStyle, 14);
    }

    public void writeObject(DefaultStyledDocument doc, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return;
        }
        Description description = (Description)value;
        DescriptionRenderer.append(doc, description.getWho(), this.whoStyle);
        DescriptionRenderer.append(doc, " - ", this.whoStyle);
        DescriptionRenderer.append(doc, dateFormat.format(description.getWhen()), this.whoStyle);
        DescriptionRenderer.append(doc, "\n", this.whoStyle);
        DescriptionRenderer.append(doc, description.getText(), this.plain);
    }
}

