/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser;

import ca.odell.glazedlists.AbstractFilterList;
import ca.odell.glazedlists.CollectionList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.demo.issuebrowser.Issue;
import ca.odell.glazedlists.demo.issuebrowser.IssueUserator;
import ca.odell.glazedlists.swing.EventListModel;
import ca.odell.glazedlists.swing.EventSelectionModel;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IssuesUserFilter
extends AbstractFilterList
implements ListSelectionListener {
    private EventList usersEventList;
    private EventList usersSelectedList;
    private JList userSelect;

    public IssuesUserFilter(EventList source) {
        super(source);
        this.usersEventList = new UniqueList(new CollectionList(source, new IssueUserator()));
        EventListModel usersListModel = new EventListModel(this.usersEventList);
        this.userSelect = new JList(usersListModel);
        EventSelectionModel userSelectionModel = new EventSelectionModel(this.usersEventList);
        this.userSelect.setSelectionModel(userSelectionModel);
        this.usersSelectedList = userSelectionModel.getSelected();
        this.userSelect.addListSelectionListener(this);
        this.handleFilterChanged();
    }

    public JList getUserSelect() {
        return this.userSelect;
    }

    public void valueChanged(ListSelectionEvent e) {
        this.handleFilterChanged();
    }

    public boolean filterMatches(Object o) {
        if (o == null) {
            return false;
        }
        if (this.usersSelectedList.isEmpty()) {
            return true;
        }
        Issue issue = (Issue)o;
        List users = issue.getAllUsers();
        Iterator u = users.iterator();
        while (u.hasNext()) {
            String user = (String)u.next();
            if (!this.usersSelectedList.contains(user)) continue;
            return true;
        }
        return false;
    }
}

