/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.demo.issuebrowser.IssuezillaXMLParser;
import ca.odell.glazedlists.demo.issuebrowser.Project;
import ca.odell.glazedlists.demo.issuebrowser.Throbber;
import java.io.IOException;

public class IssueLoader
implements Runnable {
    private Project project = null;
    private Throbber throbber = null;
    private Thread issueLoaderThread = null;
    private EventList issuesList = null;

    public IssueLoader(EventList issuesList, Throbber throbber) {
        this.issuesList = GlazedLists.threadSafeList(issuesList);
        this.throbber = throbber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProject(Project project) {
        IssueLoader issueLoader = this;
        synchronized (issueLoader) {
            this.project = project;
            this.issueLoaderThread.interrupt();
            this.notify();
        }
    }

    public void start() {
        this.issueLoaderThread = new Thread(this);
        this.issueLoaderThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Project currentProject = null;
        while (true) {
            try {
                while (true) {
                    IssueLoader issueLoader = this;
                    synchronized (issueLoader) {
                        if (this.project == null) {
                            this.wait();
                        }
                        Thread.interrupted();
                        if (this.project == null) {
                            continue;
                        }
                        currentProject = this.project;
                        this.project = null;
                    }
                    this.throbber.setOn();
                    this.issuesList.clear();
                    IssuezillaXMLParser.loadIssues(this.issuesList, currentProject.getXMLUri());
                    this.throbber.setOff();
                }
            }
            catch (IOException e) {
                if (e.getCause() instanceof InterruptedException || e.getMessage().equals("Parsing failed java.lang.InterruptedException")) continue;
                e.printStackTrace();
                continue;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof InterruptedException || e.getCause() instanceof IOException && e.getCause().getMessage().equals("Parsing failed Lock interrupted")) continue;
                throw e;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

