/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.issuebrowser;

import ca.odell.glazedlists.TextFilterable;
import ca.odell.glazedlists.demo.issuebrowser.Description;
import ca.odell.glazedlists.demo.issuebrowser.PeerIssue;
import ca.odell.glazedlists.demo.issuebrowser.Priority;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Issue
implements TextFilterable,
Comparable {
    private Integer id = null;
    private Integer statusCode = null;
    private String status = null;
    private Priority priority = null;
    private String resolution = null;
    private String component = null;
    private String version = null;
    private String repPlatform = null;
    private String assignedTo = null;
    private Date deltaTimestamp = null;
    private String subcomponent = null;
    private String reporter = null;
    private String targetMilestone = null;
    private String issueType = null;
    private Date creationTimestamp = null;
    private String qaContact = null;
    private String statusWhiteboard = null;
    private String fileLocation = null;
    private String votes = null;
    private String operatingSystem = null;
    private String shortDescription = null;
    private PeerIssue isDuplicate = null;
    private List keywords = new ArrayList();
    private List blocks = new ArrayList();
    private List cc = new ArrayList();
    private List descriptions = new ArrayList();
    private List attachments = new ArrayList();
    private List activities = new ArrayList();
    private List duplicates = new ArrayList();
    private List dependsOn = new ArrayList();
    private List allUsers = null;

    public Issue() {
    }

    public List getAllUsers() {
        if (this.allUsers == null) {
            this.allUsers = new ArrayList();
            if (this.assignedTo != null) {
                this.allUsers.add(this.assignedTo);
            }
            if (this.reporter != null) {
                this.allUsers.add(this.reporter);
            }
            if (this.qaContact != null) {
                this.allUsers.add(this.qaContact);
            }
            Iterator d = this.descriptions.iterator();
            while (d.hasNext()) {
                Description description = (Description)d.next();
                this.allUsers.add(description.getWho());
            }
        }
        return this.allUsers;
    }

    public Issue(Issue template) {
        this.id = template.id;
        this.statusCode = template.statusCode;
        this.status = template.status;
        this.priority = template.priority;
        this.resolution = template.resolution;
        this.component = template.component;
        this.version = template.version;
        this.repPlatform = template.repPlatform;
        this.assignedTo = template.assignedTo;
        this.deltaTimestamp = template.deltaTimestamp;
        this.subcomponent = template.subcomponent;
        this.reporter = template.reporter;
        this.targetMilestone = template.targetMilestone;
        this.issueType = template.issueType;
        this.creationTimestamp = template.creationTimestamp;
        this.qaContact = template.qaContact;
        this.statusWhiteboard = template.statusWhiteboard;
        this.votes = template.votes;
        this.operatingSystem = template.operatingSystem;
        this.shortDescription = template.shortDescription;
        this.keywords.addAll(template.keywords);
        this.blocks.addAll(template.blocks);
        this.dependsOn.addAll(template.dependsOn);
        this.cc.addAll(template.cc);
        this.descriptions.addAll(template.descriptions);
        this.attachments.addAll(template.attachments);
        this.activities.addAll(template.activities);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRepPlatform() {
        return this.repPlatform;
    }

    public void setRepPlatform(String repPlatform) {
        this.repPlatform = repPlatform;
    }

    public String getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    public Date getDeltaTimestamp() {
        return this.deltaTimestamp;
    }

    public void setDeltaTimestamp(Date deltaTimestamp) {
        this.deltaTimestamp = deltaTimestamp;
    }

    public String getSubcomponent() {
        return this.subcomponent;
    }

    public void setSubcomponent(String subcomponent) {
        this.subcomponent = subcomponent;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String getTargetMilestone() {
        return this.targetMilestone;
    }

    public void setTargetMilestone(String targetMilestone) {
        this.targetMilestone = targetMilestone;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public String getQAContact() {
        return this.qaContact;
    }

    public void setQAContact(String qaContact) {
        this.qaContact = qaContact;
    }

    public String getStatusWhiteboard() {
        return this.statusWhiteboard;
    }

    public void setStatusWhiteboard(String statusWhiteboard) {
        this.statusWhiteboard = statusWhiteboard;
    }

    public String getVotes() {
        return this.votes;
    }

    public void setVotes(String votes) {
        this.votes = votes;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public List getKeywords() {
        return this.keywords;
    }

    public List getCC() {
        return this.cc;
    }

    public List getDescriptions() {
        return this.descriptions;
    }

    public List getAttachments() {
        return this.attachments;
    }

    public List getActivities() {
        return this.activities;
    }

    public List getDuplicates() {
        return this.duplicates;
    }

    public List getDependsOn() {
        return this.dependsOn;
    }

    public List getBlocks() {
        return this.blocks;
    }

    public PeerIssue getDuplicate() {
        return this.isDuplicate;
    }

    public void setDuplicate(PeerIssue peerIssue) {
        this.isDuplicate = this.isDuplicate;
    }

    public String toString() {
        return "Issue " + this.id + ": " + this.getPriority().getRating();
    }

    public int compareTo(Object other) {
        if (other == null) {
            return -1;
        }
        Issue otherIssue = (Issue)other;
        return this.id.compareTo(otherIssue.id);
    }

    public void getFilterStrings(List baseList) {
        baseList.add(this.id);
        baseList.add(this.issueType);
        baseList.add(this.priority.toString());
        baseList.add(this.status);
        baseList.add(this.resolution);
        baseList.add(this.shortDescription);
        baseList.add(this.component);
        baseList.add(this.subcomponent);
        for (int d = 0; d < this.getDescriptions().size(); ++d) {
            Description description = (Description)this.getDescriptions().get(d);
            description.getFilterStrings(baseList);
        }
    }
}

