/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo.collectionlist;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CollectionList;
import ca.odell.glazedlists.CollectionListModel;
import ca.odell.glazedlists.demo.Launcher;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AlbumBrowser {
    public static void main(String[] args) throws Exception {
        String arg0;
        File song_file = null;
        if (args.length > 0 && !(song_file = new File(arg0 = args[0])).exists()) {
            System.out.println("Usage: CollectionListTest <song_list>");
            System.out.println("<song_list> must be a tab-delimited file with song in the first column and album in the second. The first row is considered to be a header and will be skipped.");
            System.err.println("  File not found: " + song_file);
            return;
        }
        final BasicEventList parent_event_list = new BasicEventList();
        long start = System.currentTimeMillis();
        AlbumBrowser.importSongList(parent_event_list, song_file);
        System.out.println("Time to import song list: " + (System.currentTimeMillis() - start));
        final JList record_list = new JList(new EventListModel(parent_event_list));
        record_list.setSelectionMode(0);
        JScrollPane record_list_scroller = new JScrollPane(record_list);
        record_list_scroller.setBorder(new TitledBorder("Records"));
        start = System.currentTimeMillis();
        final CollectionList song_event_list = new CollectionList(parent_event_list, new RecordCollectionListModel());
        System.out.println("Time to create CollectionList: " + (System.currentTimeMillis() - start));
        final JList song_list = new JList(new EventListModel(song_event_list));
        JScrollPane song_list_scroller = new JScrollPane(song_list);
        song_list_scroller.setBorder(new TitledBorder("Songs"));
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(record_list_scroller);
        panel.add(song_list_scroller);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "Center");
        JPanel button_panel = new JPanel(new FlowLayout(3));
        panel2.add((Component)button_panel, "North");
        JButton add = new JButton("Add Front");
        add.setActionCommand("FRONT");
        button_panel.add(add);
        JButton add_end = new JButton("Add End");
        add_end.setActionCommand("END");
        button_panel.add(add_end);
        ActionListener add_listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Record rec = new Record("New Record " + System.currentTimeMillis(), new String[]{"One", "Two", "Three"});
                long start = System.currentTimeMillis();
                if (e.getActionCommand().equals("FRONT")) {
                    parent_event_list.add(0, rec);
                } else {
                    parent_event_list.add(rec);
                }
                System.out.println("Time to add album: " + (System.currentTimeMillis() - start));
            }
        };
        add.addActionListener(add_listener);
        add_end.addActionListener(add_listener);
        JButton remove_front = new JButton("Remove Front");
        remove_front.setActionCommand("FRONT");
        button_panel.add(remove_front);
        JButton remove_end = new JButton("Remove End");
        remove_end.setActionCommand("END");
        button_panel.add(remove_end);
        ActionListener remove_listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (parent_event_list.size() <= 0) {
                    return;
                }
                long start = System.currentTimeMillis();
                if (e.getActionCommand().equals("FRONT")) {
                    parent_event_list.remove(0);
                } else {
                    parent_event_list.remove(parent_event_list.size() - 1);
                }
                System.out.println("Time to remove album: " + (System.currentTimeMillis() - start));
            }
        };
        remove_front.addActionListener(remove_listener);
        remove_end.addActionListener(remove_listener);
        JButton add_song = new JButton("Add Song");
        add_song.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Record r = (Record)parent_event_list.get(0);
                r.addSong("Song " + System.currentTimeMillis());
                long start = System.currentTimeMillis();
                parent_event_list.set(0, r);
                System.out.println("Time to add song: " + (System.currentTimeMillis() - start));
            }
        });
        button_panel.add(add_song);
        JButton remove_song = new JButton("Remove Song");
        remove_song.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Record r = (Record)parent_event_list.get(0);
                r.removeSong();
                long start = System.currentTimeMillis();
                parent_event_list.set(0, r);
                System.out.println("Time to remove song: " + (System.currentTimeMillis() - start));
            }
        });
        button_panel.add(remove_song);
        record_list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int parent_index = record_list.getSelectedIndex();
                int start = song_event_list.childStartingIndex(parent_index);
                int end = song_event_list.childEndingIndex(parent_index);
                song_list.setSelectionInterval(start, end);
                song_list.ensureIndexIsVisible(end);
                song_list.ensureIndexIsVisible(start);
            }
        });
        JFrame frame = new JFrame("Test");
        if (!Launcher.runningInLauncher()) {
            frame.setDefaultCloseOperation(3);
        } else {
            frame.setDefaultCloseOperation(2);
        }
        frame.setContentPane(panel2);
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importSongList(BasicEventList event_list, File song_file) throws IOException {
        InputStreamReader in = null;
        BufferedReader br = null;
        try {
            String line;
            if (song_file != null) {
                in = new FileReader(song_file);
            } else {
                try {
                    InputStream is = AlbumBrowser.class.getResourceAsStream("Library.txt");
                    in = is != null ? new InputStreamReader(is) : new FileReader("Library.txt");
                }
                catch (IOException ex) {
                    System.err.println("Unable to load the default library file. If the build problem can't be found, try manually specifying a file.");
                    throw ex;
                }
            }
            br = new BufferedReader(in);
            String last_album = null;
            LinkedList<String> song_list = new LinkedList<String>();
            System.out.print("Loading albums: ");
            int record_count = 0;
            boolean first_print = true;
            int i = 0;
            while ((line = br.readLine()) != null) {
                String[] toks;
                if (i != 0 && (toks = line.split("\t")) != null && toks.length >= 2) {
                    String song = toks[0];
                    String album = toks[1];
                    if (last_album != null && !last_album.equals(album)) {
                        Record record = new Record(last_album, song_list.toArray(new String[song_list.size()]));
                        event_list.add(record);
                        ++record_count;
                        song_list.clear();
                    }
                    last_album = album;
                    if (!AlbumBrowser.isEmpty(song) && !AlbumBrowser.isEmpty(album)) {
                        song_list.add(song);
                        if (i % 100 == 0) {
                            if (!first_print) {
                                System.out.print("...");
                            }
                            first_print = false;
                            System.out.print(i);
                        }
                    }
                }
                ++i;
            }
            System.out.println("done: " + record_count);
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                ((Reader)in).close();
            }
        }
    }

    private static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return (str = str.trim()).length() == 0;
    }

    static class RecordCollectionListModel
    implements CollectionListModel {
        RecordCollectionListModel() {
        }

        public List getChildren(Object parent) {
            return (Record)parent;
        }
    }

    static class Record
    extends AbstractList {
        String name;
        String[] songs;

        Record(String name, String[] songs) {
            this.name = name;
            this.songs = songs;
        }

        public String toString() {
            return this.name;
        }

        public int getSongCount() {
            return this.songs.length;
        }

        public String getSong(int index) {
            return this.songs[index];
        }

        public void addSong(String song) {
            String[] tmp = new String[this.songs.length + 1];
            System.arraycopy(this.songs, 0, tmp, 0, this.songs.length);
            tmp[this.songs.length] = song;
            this.songs = tmp;
        }

        public void removeSong() {
            if (this.songs.length <= 0) {
                return;
            }
            String[] tmp = new String[this.songs.length - 1];
            System.arraycopy(this.songs, 0, tmp, 0, tmp.length);
            this.songs = tmp;
        }

        public Object get(int index) {
            return this.getSong(index);
        }

        public int size() {
            return this.getSongCount();
        }
    }
}

