/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.demo;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Launcher
implements ActionListener,
ListSelectionListener {
    private static final String LOGO_FILE = "/resources/demo/logoonbrown.gif";
    private static final String DEMO_PROPERTY_FILE = "/resources/demo/launcher.properties";
    private static final Color BACKGROUND_COLOR = new Color(102, 51, 0);
    private static final Color FOREGROUND_COLOR = new Color(255, 204, 0);
    private static final Color SECTION_HEADER_BACKGROUND = new Color(255, 119, 0);
    private static final Color SECTION_HEADER_FOREGROUND = BACKGROUND_COLOR;
    private static final Color LINK_BAR_BACKGROUND = BACKGROUND_COLOR;
    private static final Color LINK_BAR_BACKGROUND_ROLLOVER = new Color(119, 72, 0);
    private static final Color LINK_BAR_FOREGROUND = new Color(255, 153, 0);
    private static final String HELP_TEXT_COLOR = "#663300";
    private static final String WELCOME_TEXT = "<html>Welcome to the Glazed Lists demo launcher!<br><br>These demos will help show off some of Glazed Lists' features and serve as a guide when creating your own applications.<br><br>Choose a demo from the list below to get started:</html>";
    private static final String MAIN_PAGE_URL = "http://publicobject.com/glazedlists/";
    private static final String JAVA_NET_URL = "http://glazedlists.dev.java.net/";
    private static final String TUTORIAL_URL = "http://publicobject.com/glazedlists/tutorial/";
    private static final String JAVADOC_URL = "http://publicobject.com/glazedlists/api/";
    private static final String FAQ_URL = "http://publicobject.com/glazedlists/faq.html";
    private static final Class STRING_ARRAY_CLASS = new String[0].getClass();
    private static boolean in_launcher = false;
    private JList demo_list;
    private JButton launch_button;
    private JEditorPane help_text_viewer;

    public static void main(String[] args) {
        in_launcher = true;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Launcher();
    }

    public static boolean runningInLauncher() {
        return in_launcher;
    }

    private Launcher() {
        URL duke_of = Launcher.class.getResource(LOGO_FILE);
        JLabel logo_label = null;
        if (duke_of != null) {
            logo_label = new JLabel(new ImageIcon(duke_of));
            logo_label.setBackground(BACKGROUND_COLOR);
            logo_label.setOpaque(true);
        }
        JPanel top_left = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 100.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        if (logo_label != null) {
            top_left.add((Component)logo_label, gbc);
            ++gbc.gridy;
            this.addWebStartLinks(top_left, gbc);
        }
        JPanel left_panel = new JPanel(new BorderLayout(0, 0));
        left_panel.setOpaque(true);
        left_panel.setBackground(BACKGROUND_COLOR);
        left_panel.setBorder(new EmptyBorder(5, 0, 0, 0));
        left_panel.add((Component)top_left, "First");
        JLabel header = new JLabel("Glazed Lists");
        header.setOpaque(true);
        header.setForeground(FOREGROUND_COLOR);
        header.setBackground(BACKGROUND_COLOR);
        header.setBorder(new EmptyBorder(5, 0, 5, 0));
        Font font = header.getFont();
        font = new Font(font.getName(), 1, font.getSize() + 10);
        header.setFont(font);
        JPanel main_panel = new JPanel(new BorderLayout());
        main_panel.setOpaque(false);
        main_panel.add((Component)header, "First");
        JPanel content_panel = this.buildContentPanel();
        main_panel.add((Component)content_panel, "Center");
        JPanel outer_panel = new JPanel(new BorderLayout());
        outer_panel.add((Component)left_panel, "Before");
        outer_panel.add((Component)main_panel, "Center");
        outer_panel.setBackground(Color.WHITE);
        JFrame frame = new JFrame("Glazed Lists");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(outer_panel);
        frame.setSize(new Dimension(550, 350));
        this.centerWindow(frame);
        frame.setVisible(true);
    }

    private JPanel buildContentPanel() {
        JLabel welcome_label = new JLabel(WELCOME_TEXT);
        EventList root_list = GlazedLists.eventList(this.loadDemos());
        SortedList sorter = new SortedList(root_list);
        this.demo_list = new JList(new EventListModel(sorter));
        this.demo_list.setSelectionMode(0);
        this.demo_list.getSelectionModel().addListSelectionListener(this);
        JScrollPane scroller = new JScrollPane(this.demo_list, 20, 31);
        Dimension dim = this.demo_list.getPreferredScrollableViewportSize();
        dim.width += 10;
        scroller.setPreferredSize(dim);
        this.help_text_viewer = new JEditorPane();
        this.help_text_viewer.setEditable(false);
        this.help_text_viewer.setBorder(null);
        this.help_text_viewer.setContentType("text/html");
        this.help_text_viewer.setOpaque(true);
        this.help_text_viewer.setBackground(Color.WHITE);
        JScrollPane help_scroller = new JScrollPane(this.help_text_viewer, 20, 31);
        help_scroller.setPreferredSize(new Dimension(150, dim.height));
        help_scroller.setBorder(null);
        help_scroller.getViewport().setOpaque(false);
        this.launch_button = new JButton("Launch...");
        this.launch_button.setOpaque(false);
        this.launch_button.addActionListener(this);
        this.launch_button.setEnabled(false);
        JPanel help_launch_panel = new JPanel(new BorderLayout());
        help_launch_panel.setOpaque(false);
        help_launch_panel.setBorder(new EmptyBorder(0, 7, 0, 0));
        help_launch_panel.add((Component)help_scroller, "Center");
        JPanel filler = new JPanel(new FlowLayout(1));
        filler.setOpaque(false);
        filler.add(this.launch_button);
        help_launch_panel.add((Component)filler, "Last");
        JPanel inner_panel = new JPanel(new BorderLayout());
        inner_panel.setOpaque(false);
        inner_panel.add((Component)scroller, "Before");
        inner_panel.add((Component)help_launch_panel, "Center");
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.setOpaque(false);
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add((Component)welcome_label, "First");
        panel.add((Component)inner_panel, "Center");
        return panel;
    }

    private void addWebStartLinks(JPanel box, GridBagConstraints gbc) {
        Method show_document_method;
        Object basic_service;
        try {
            Class<?> service_manager_class = Class.forName("javax.jnlp.ServiceManager");
            Method service_names_method = service_manager_class.getMethod("getServiceNames", new Class[0]);
            String[] service_names = (String[])service_names_method.invoke(service_manager_class, new Object[0]);
            if (service_names == null || service_names.length == 0) {
                return;
            }
            Class<?> basic_service_class = Class.forName("javax.jnlp.BasicService");
            Method lookup_method = service_manager_class.getMethod("lookup", String.class);
            basic_service = lookup_method.invoke(service_manager_class, basic_service_class.getName());
            Method web_browser_supported_method = basic_service_class.getMethod("isWebBrowserSupported", new Class[0]);
            Boolean bool = (Boolean)web_browser_supported_method.invoke(basic_service, new Object[0]);
            if (bool == null || !bool.booleanValue()) {
                return;
            }
            show_document_method = basic_service_class.getMethod("showDocument", URL.class);
        }
        catch (Exception ex) {
            return;
        }
        box.add((Component)this.createHeaderLabel("Links"), gbc);
        ++gbc.gridy;
        try {
            box.add((Component)this.createLinkBarLabel("Main Website", new URL(MAIN_PAGE_URL), basic_service, show_document_method), gbc);
            ++gbc.gridy;
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        try {
            box.add((Component)this.createLinkBarLabel("Java.net", new URL(JAVA_NET_URL), basic_service, show_document_method), gbc);
            ++gbc.gridy;
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        JPanel filler = new JPanel();
        filler.setBackground(BACKGROUND_COLOR);
        filler.setPreferredSize(new Dimension(1, 5));
        filler.setMinimumSize(new Dimension(1, 5));
        filler.setMaximumSize(new Dimension(10000, 5));
        box.add((Component)filler, gbc);
        ++gbc.gridy;
        box.add((Component)this.createHeaderLabel("Documentation"), gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        ++gbc.gridy;
        try {
            box.add((Component)this.createLinkBarLabel("Tutorial", new URL(TUTORIAL_URL), basic_service, show_document_method), gbc);
            ++gbc.gridy;
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        try {
            box.add((Component)this.createLinkBarLabel("Javadoc API", new URL(JAVADOC_URL), basic_service, show_document_method), gbc);
            ++gbc.gridy;
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        try {
            box.add((Component)this.createLinkBarLabel("FAQ", new URL(FAQ_URL), basic_service, show_document_method), gbc);
            ++gbc.gridy;
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Object selected_value = this.demo_list.getSelectedValue();
        this.launch_button.setEnabled(selected_value != null);
        if (selected_value == null) {
            this.help_text_viewer.setText("");
        } else {
            this.help_text_viewer.setText("<html><body bgcolor=\"#ffffff\"><font color=\"#663300\">" + ((Demo)selected_value).help_text + "</font></body></html>");
        }
    }

    public void actionPerformed(ActionEvent e) {
        Demo demo = (Demo)this.demo_list.getSelectedValue();
        if (demo == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(demo.class_name);
            Method method = clazz.getMethod("main", STRING_ARRAY_CLASS);
            method.invoke(clazz, new Object[]{new String[0]});
        }
        catch (Exception ex) {
            this.handleError(ex, "attempting to run the demo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadDemos() {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = Launcher.class.getResourceAsStream(DEMO_PROPERTY_FILE);
            props.load(in);
        }
        catch (Exception ex) {
            this.handleError(ex, "loading data about the demos");
            System.exit(-1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
        LinkedList<Demo> demo_list = new LinkedList<Demo>();
        boolean is_swt_available = false;
        try {
            Class.forName("org.eclipse.swt.SWT");
            is_swt_available = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            boolean requires_swt;
            String name = (String)enumeration.nextElement();
            if (name.endsWith(".class") || name.endsWith(".desc") || name.endsWith(".requires_swt")) continue;
            String demo_name = props.getProperty(name, null);
            String demo_class = props.getProperty(name + ".class", null);
            String demo_help = props.getProperty(name + ".desc", "No help text available");
            if (this.isEmpty(demo_name)) {
                System.err.println("Empty name for property \"" + name + "\". Check format");
                continue;
            }
            if (this.isEmpty(demo_class)) {
                System.err.println("Empty class name for property \"" + name + "\". Check format");
                continue;
            }
            boolean bl = requires_swt = props.getProperty(name + ".requires_swt", null) != null;
            if (requires_swt && !is_swt_available) {
                System.err.println("Skipping demo \"" + demo_name + "\" because SWT isn't available.");
                continue;
            }
            try {
                Class.forName(demo_class);
            }
            catch (Exception ex) {
                System.err.println("Skipping demo \"" + demo_name + "\" because the class couldn't be loaded:");
                ex.printStackTrace();
                continue;
            }
            demo_list.add(new Demo(demo_name, demo_help, demo_class));
        }
        return demo_list;
    }

    private boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().length() == 0;
    }

    private void handleError(Exception ex, String location) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        StringBuffer buf = new StringBuffer("Sorry, an error occurred ");
        buf.append(location).append(".\n");
        buf.append("Please report this error to \"issues@glazedlists.dev.java.net\"");
        buf.append("\n\n");
        buf.append("Exception:\n");
        buf.append(writer.getBuffer());
        JOptionPane.showMessageDialog(null, buf, "Error", 0);
    }

    private JLabel createHeaderLabel(String text) {
        JLabel label = new JLabel(text);
        label.setOpaque(true);
        label.setBackground(SECTION_HEADER_BACKGROUND);
        label.setForeground(SECTION_HEADER_FOREGROUND);
        label.setBorder(new EmptyBorder(3, 3, 3, 3));
        Font font = label.getFont();
        label.setFont(new Font(font.getName(), 0, font.getSize() + 5));
        return label;
    }

    private JLabel createLinkBarLabel(String text, final URL url, final Object basic_service, final Method show_document_method) {
        final JLabel label = new JLabel(text);
        label.setOpaque(true);
        label.setBackground(LINK_BAR_BACKGROUND);
        label.setForeground(LINK_BAR_FOREGROUND);
        label.setBorder(new EmptyBorder(0, 3, 0, 0));
        Font font = label.getFont();
        label.setFont(new Font(font.getName(), 0, font.getSize() - 2));
        label.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                label.setBackground(LINK_BAR_BACKGROUND_ROLLOVER);
            }

            public void mouseExited(MouseEvent e) {
                label.setBackground(LINK_BAR_BACKGROUND);
            }

            public void mouseClicked(MouseEvent e) {
                try {
                    show_document_method.invoke(basic_service, url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return label;
    }

    private void centerWindow(Window window) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension win_size = window.getSize();
        Point window_point = new Point(center.x - win_size.width / 2, center.y - win_size.height / 2);
        window.setLocation(window_point);
    }

    private class Demo
    implements Comparable {
        String name;
        String help_text;
        String class_name;

        Demo(String name, String help_text, String class_name) {
            this.name = name;
            this.help_text = help_text;
            this.class_name = class_name;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object o) {
            return this.name.compareTo(((Demo)o).name);
        }
    }
}

