/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.sort.ComparableComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;

public final class UniqueList
extends TransformedList {
    private Comparator comparator;
    private Barcode duplicatesList = new Barcode();
    private static final Object UNIQUE = Barcode.BLACK;
    private static final Object DUPLICATE = Barcode.WHITE;
    private int pendingUpdateIndex = -1;
    private int lastInsertIndex = -1;
    private boolean includeCountChangeEvents = false;
    private static final int NEIGHBOUR_LEFT = -1;
    private static final int NEIGHBOUR_NONE = 0;
    private static final int NEIGHBOUR_RIGHT = 1;

    public UniqueList(EventList source, Comparator comparator) {
        super(new SortedList(source, comparator));
        SortedList sortedSource = (SortedList)this.source;
        this.comparator = comparator;
        this.populateDuplicatesList();
        sortedSource.addListEventListener(this);
    }

    public UniqueList(EventList source) {
        this(source, GlazedLists.comparableComparator());
    }

    public int size() {
        return this.duplicatesList.blackSize();
    }

    protected int getSourceIndex(int index) {
        return this.duplicatesList.getIndex(index, Barcode.BLACK);
    }

    protected boolean isWritable() {
        return true;
    }

    public void listChanged(ListEvent listChanges) {
        int changeType;
        int changeIndex;
        Barcode tempUniqueList = new Barcode();
        tempUniqueList.addWhite(0, this.duplicatesList.size());
        LinkedList<Object> removedValues = new LinkedList<Object>();
        while (listChanges.next()) {
            changeIndex = listChanges.getIndex();
            changeType = listChanges.getType();
            if (changeType == 2) {
                this.duplicatesList.addBlack(changeIndex, 1);
                tempUniqueList.addBlack(changeIndex, 1);
                continue;
            }
            if (changeType == 1) {
                Object replaced = this.duplicatesList.get(changeIndex);
                if (replaced != UNIQUE || changeIndex + 1 >= this.duplicatesList.size() || this.duplicatesList.get(changeIndex + 1) != DUPLICATE) continue;
                this.duplicatesList.setBlack(changeIndex, 2);
                tempUniqueList.setBlack(changeIndex, 1);
                continue;
            }
            if (changeType != 0) continue;
            Object deleted = this.duplicatesList.get(changeIndex);
            this.duplicatesList.remove(changeIndex, 1);
            tempUniqueList.remove(changeIndex, 1);
            if (deleted == UNIQUE && changeIndex < this.duplicatesList.size() && this.duplicatesList.get(changeIndex) == DUPLICATE) {
                this.duplicatesList.setBlack(changeIndex, 1);
                deleted = null;
            }
            removedValues.addLast(deleted);
        }
        this.updates.beginEvent();
        listChanges.reset();
        while (listChanges.next()) {
            changeIndex = listChanges.getIndex();
            changeType = listChanges.getType();
            if (changeType == 2) {
                int neighbourSide = this.handleOldNeighbour(changeIndex, tempUniqueList);
                if (neighbourSide != 0) {
                    this.enqueueEvent(1, this.duplicatesList.getBlackIndex(changeIndex, true), false);
                    continue;
                }
                this.enqueueEvent(2, this.duplicatesList.getBlackIndex(changeIndex), true);
                continue;
            }
            if (changeType == 1) {
                int oldNeighbourSide = 0;
                Object updated = this.duplicatesList.get(changeIndex);
                if (tempUniqueList.get(changeIndex) == Barcode.BLACK) {
                    updated = null;
                }
                if (updated == DUPLICATE) {
                    oldNeighbourSide = -1;
                } else if (updated == null) {
                    oldNeighbourSide = 1;
                } else if (updated == UNIQUE) {
                    oldNeighbourSide = 0;
                }
                int newNeighbourSide = this.handleOldNeighbour(changeIndex, tempUniqueList);
                int compressedIndex = this.duplicatesList.getBlackIndex(changeIndex, true);
                if (newNeighbourSide == 0) {
                    if (oldNeighbourSide == 0) {
                        this.enqueueEvent(1, compressedIndex, true);
                        continue;
                    }
                    if (oldNeighbourSide == -1) {
                        this.enqueueEvent(1, compressedIndex - 1, false);
                        this.enqueueEvent(2, compressedIndex, true);
                        continue;
                    }
                    if (oldNeighbourSide != 1) continue;
                    this.enqueueEvent(2, compressedIndex, true);
                    this.enqueueEvent(1, compressedIndex + 1, false);
                    continue;
                }
                if (newNeighbourSide == -1) {
                    if (oldNeighbourSide == 0) {
                        this.enqueueEvent(1, compressedIndex, false);
                        this.enqueueEvent(0, compressedIndex + 1, true);
                        continue;
                    }
                    if (oldNeighbourSide == -1) {
                        this.enqueueEvent(1, compressedIndex, false);
                        continue;
                    }
                    if (oldNeighbourSide != 1) continue;
                    this.enqueueEvent(1, compressedIndex, false);
                    if (compressedIndex + 1 >= this.duplicatesList.blackSize()) continue;
                    this.enqueueEvent(1, compressedIndex + 1, false);
                    continue;
                }
                if (newNeighbourSide != 1) continue;
                if (oldNeighbourSide == 0) {
                    this.enqueueEvent(0, compressedIndex, true);
                    this.enqueueEvent(1, compressedIndex, false);
                    continue;
                }
                if (oldNeighbourSide == -1) {
                    if (compressedIndex - 1 >= 0) {
                        this.enqueueEvent(1, compressedIndex - 1, false);
                    }
                    this.enqueueEvent(1, compressedIndex, false);
                    continue;
                }
                if (oldNeighbourSide != 1) continue;
                this.enqueueEvent(1, compressedIndex, false);
                continue;
            }
            if (changeType != 0) continue;
            Object deleted = removedValues.removeFirst();
            int uncompressedIndex = -1;
            uncompressedIndex = deleted == DUPLICATE ? changeIndex - 1 : changeIndex;
            int deletedIndex = -1;
            deletedIndex = uncompressedIndex < this.duplicatesList.size() ? this.duplicatesList.getBlackIndex(uncompressedIndex, true) : this.duplicatesList.blackSize();
            if (deleted == UNIQUE) {
                this.enqueueEvent(0, deletedIndex, true);
                continue;
            }
            this.enqueueEvent(1, deletedIndex, false);
        }
        this.flushEnqueuedEvents();
        this.updates.commitEvent();
    }

    private int handleOldNeighbour(int changeIndex, Barcode tempUniqueList) {
        if (this.valuesEqual(changeIndex - 1, changeIndex)) {
            this.duplicatesList.setWhite(changeIndex, 1);
            return -1;
        }
        int followerIndex = changeIndex + 1;
        while (this.valuesEqual(changeIndex, followerIndex)) {
            Object followerType = tempUniqueList.get(followerIndex) == Barcode.BLACK ? null : this.duplicatesList.get(followerIndex);
            if (followerType == null) {
                ++followerIndex;
                continue;
            }
            this.duplicatesList.setBlack(changeIndex, 1);
            this.duplicatesList.setWhite(followerIndex, 1);
            return 1;
        }
        this.duplicatesList.setBlack(changeIndex, 1);
        return 0;
    }

    private void enqueueEvent(int type, int index, boolean mandatory) {
        if (mandatory || this.includeCountChangeEvents) {
            if (this.pendingUpdateIndex != -1 && this.pendingUpdateIndex != index) {
                this.updates.addChange(1, this.pendingUpdateIndex);
            }
            this.pendingUpdateIndex = -1;
            if (type == 1 && index != this.lastInsertIndex) {
                this.pendingUpdateIndex = index;
            } else if (type == 2) {
                this.lastInsertIndex = index;
                this.updates.addChange(type, index);
            } else if (type == 0) {
                this.updates.addChange(type, index);
            }
        }
    }

    private void flushEnqueuedEvents() {
        if (this.pendingUpdateIndex != -1) {
            this.updates.addChange(1, this.pendingUpdateIndex);
        }
        this.pendingUpdateIndex = -1;
        this.lastInsertIndex = -1;
    }

    void setFireCountChangeEvents(boolean includeCountChangeEvents) {
        this.includeCountChangeEvents = includeCountChangeEvents;
    }

    public int getCount(int index) {
        if (index < this.size() - 1) {
            return this.duplicatesList.getIndex(index + 1, Barcode.BLACK) - this.duplicatesList.getIndex(index, Barcode.BLACK);
        }
        return this.source.size() - this.duplicatesList.getIndex(index, Barcode.BLACK);
    }

    public int getCount(Object value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return 0;
        }
        return this.getCount(index);
    }

    public List getAll(int index) {
        if (index < this.size() - 1) {
            return this.source.subList(this.duplicatesList.getIndex(index, Barcode.BLACK), this.duplicatesList.getIndex(index + 1, Barcode.BLACK));
        }
        return this.source.subList(this.duplicatesList.getIndex(index, Barcode.BLACK), this.source.size());
    }

    public List getAll(Object value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return Collections.EMPTY_LIST;
        }
        return this.getAll(index);
    }

    private void populateDuplicatesList() {
        if (!this.duplicatesList.isEmpty()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < this.source.size(); ++i) {
            if (!this.valuesEqual(i, i - 1)) {
                this.duplicatesList.addBlack(i, 1);
                continue;
            }
            this.duplicatesList.addWhite(i, 1);
        }
    }

    private boolean valuesEqual(int index0, int index1) {
        if (index0 < 0 || index0 >= this.source.size()) {
            return false;
        }
        if (index1 < 0 || index1 >= this.source.size()) {
            return false;
        }
        return 0 == this.comparator.compare(this.source.get(index0), this.source.get(index1));
    }

    public Object remove(int index) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + index + " on list of size " + this.size());
        }
        Object removed = this.get(index);
        int removeStart = this.getSourceIndex(index);
        int removeEnd = removeStart + this.getCount(index);
        this.source.subList(removeStart, removeEnd).clear();
        return removed;
    }

    public boolean remove(Object toRemove) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        int index = this.indexOf(toRemove);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public Object set(int index, Object value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List cannot be modified in the current state");
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + index + " on list of size " + this.size());
        }
        Object replaced = this.get(index);
        this.updates.beginEvent(true);
        int removeStart = this.getSourceIndex(index) + 1;
        int removeEnd = removeStart + this.getCount(index) - 1;
        if (removeStart < removeEnd) {
            this.source.subList(removeStart, removeEnd).clear();
        }
        this.source.set(this.getSourceIndex(index), value);
        this.updates.commitEvent();
        return replaced;
    }

    public void replaceAll(SortedSet revision) {
        if (revision == null) {
            return;
        }
        if (revision.comparator() == null ? !(this.comparator instanceof ComparableComparator) : !((Object)revision.comparator()).equals(this.comparator)) {
            throw new IllegalArgumentException("SortedSet comparator " + revision.comparator() + " != " + this.comparator);
        }
        this.updates.beginEvent(true);
        int originalIndex = 0;
        Object originalElement = this.getOrNull(this, originalIndex);
        Iterator revisionIterator = revision.iterator();
        while (revisionIterator.hasNext()) {
            Object revisionElement = revisionIterator.next();
            while (originalElement != null && this.comparator.compare(originalElement, revisionElement) < 0) {
                this.remove(originalIndex);
                originalElement = this.getOrNull(this, originalIndex);
            }
            if (originalElement != null && this.comparator.compare(originalElement, revisionElement) == 0) {
                this.set(originalIndex, revisionElement);
                originalElement = this.getOrNull(this, ++originalIndex);
                continue;
            }
            this.add(originalIndex, revisionElement);
            ++originalIndex;
        }
        while (originalIndex < this.size()) {
            this.remove(originalIndex);
        }
        this.updates.commitEvent();
    }

    private Object getOrNull(List source, int index) {
        if (index < source.size()) {
            return source.get(index);
        }
        return null;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public int indexOf(Object object) {
        int sourceIndex = this.source.indexOf(object);
        if (sourceIndex == -1) {
            return -1;
        }
        return this.duplicatesList.getBlackIndex(sourceIndex, true);
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public void dispose() {
        SortedList sortedSource = (SortedList)this.source;
        super.dispose();
        sortedSource.dispose();
    }
}

