/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;

public class RangeList
extends TransformedList {
    private int desiredStart = 0;
    private int desiredEnd = -1;
    private int currentStartIndex = 0;
    private int currentEndIndex;

    protected RangeList(EventList source) {
        super(source);
        this.currentEndIndex = source.size();
        source.addListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.beginEvent(true);
        while (listChanges.next()) {
            int changeType = listChanges.getType();
            int changeIndex = listChanges.getIndex();
            if (changeType == 0) {
                if (changeIndex < this.currentStartIndex) {
                    --this.currentStartIndex;
                    --this.currentEndIndex;
                    continue;
                }
                if (changeIndex >= this.currentEndIndex) continue;
                --this.currentEndIndex;
                this.updates.addDelete(changeIndex - this.currentStartIndex);
                continue;
            }
            if (changeType == 2) {
                if (changeIndex < this.currentStartIndex) {
                    ++this.currentStartIndex;
                    ++this.currentEndIndex;
                    continue;
                }
                if (changeIndex >= this.currentEndIndex) continue;
                ++this.currentEndIndex;
                this.updates.addInsert(changeIndex - this.currentStartIndex);
                continue;
            }
            if (changeType != 1) continue;
            this.updates.addUpdate(changeIndex - this.currentStartIndex);
        }
        this.setRange(this.desiredStart, this.desiredEnd);
        this.updates.commitEvent();
    }

    public void setRange(int desiredStart, int desiredEnd) {
        int desiredEndIndex;
        this.desiredStart = desiredStart;
        this.desiredEnd = desiredEnd;
        this.updates.beginEvent(true);
        int desiredStartIndex = desiredStart >= 0 ? desiredStart : this.source.size() + desiredStart + 1;
        int n = desiredEndIndex = desiredEnd >= 0 ? desiredEnd : this.source.size() + desiredEnd + 1;
        if (desiredStartIndex < 0) {
            desiredStartIndex = 0;
        } else if (desiredStartIndex > this.source.size()) {
            desiredStartIndex = this.source.size();
        }
        if (desiredEndIndex < desiredStartIndex) {
            desiredEndIndex = desiredStartIndex;
        } else if (desiredEndIndex > this.source.size()) {
            desiredEndIndex = this.source.size();
        }
        if (desiredStartIndex < this.currentStartIndex) {
            this.updates.addInsert(0, this.currentStartIndex - desiredStartIndex - 1);
        } else if (this.currentStartIndex < desiredStartIndex && this.currentStartIndex < this.currentEndIndex) {
            int deleteThru = Math.min(desiredStartIndex, this.currentEndIndex);
            this.updates.addDelete(0, deleteThru - this.currentStartIndex - 1);
        }
        this.currentStartIndex = desiredStartIndex;
        if (desiredEndIndex < this.currentEndIndex) {
            int deleteFrom = Math.max(desiredEndIndex, this.currentStartIndex);
            this.updates.addDelete(deleteFrom - this.currentStartIndex, this.currentEndIndex - this.currentStartIndex - 1);
        } else if (this.currentEndIndex < desiredEndIndex && desiredStartIndex < desiredEndIndex) {
            int insertFrom = Math.max(this.currentEndIndex, this.currentStartIndex);
            this.updates.addInsert(insertFrom - this.currentStartIndex, desiredEndIndex - this.currentStartIndex - 1);
        }
        this.currentEndIndex = desiredEndIndex;
        this.updates.commitEvent();
    }

    public void setTailRange(int desiredStart, int desiredEnd) {
        this.setRange(-desiredStart - 1, -desiredEnd - 1);
    }

    public int size() {
        return this.currentEndIndex - this.currentStartIndex;
    }

    protected int getSourceIndex(int mutationIndex) {
        return mutationIndex + this.currentStartIndex;
    }
}

