/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.Comparator;

public final class PopularityList
extends TransformedList {
    private UniqueList uniqueList;

    public PopularityList(EventList source, Comparator uniqueComparator) {
        this(source, new UniqueList(source, uniqueComparator));
    }

    public PopularityList(EventList source) {
        this(source, new UniqueList(source));
    }

    private PopularityList(EventList source, UniqueList uniqueList) {
        super(new SortedList(uniqueList, new PopularityComparator(uniqueList)));
        this.uniqueList = uniqueList;
        uniqueList.setFireCountChangeEvents(true);
        ((SortedList)this.source).addListEventListener(this);
    }

    protected boolean isWritable() {
        return true;
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    public void dispose() {
        SortedList sortedSource = (SortedList)this.source;
        super.dispose();
        sortedSource.dispose();
        this.uniqueList.dispose();
    }

    private static class PopularityComparator
    implements Comparator {
        private UniqueList target;

        public PopularityComparator(UniqueList target) {
            this.target = target;
        }

        public int compare(Object a, Object b) {
            int aCount = this.target.getCount(a);
            int bCount = this.target.getCount(b);
            return bCount - aCount;
        }
    }
}

