/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListSelection {
    public static final int SINGLE_SELECTION = 0;
    public static final int SINGLE_INTERVAL_SELECTION = 1;
    public static final int MULTIPLE_INTERVAL_SELECTION = 2;
    public static final int MULTIPLE_INTERVAL_SELECTION_DEFENSIVE = 103;
    private final EventList source;
    private final SelectedList selectedList;
    private final DeselectedList deselectedList;
    private final SourceListener sourceListener = new SourceListener();
    private Barcode barcode = new Barcode();
    private int leadSelectionIndex = -1;
    private int anchorSelectionIndex = -1;
    private int selectionMode = 103;
    private Object selected = Barcode.BLACK;
    private Object deselected = Barcode.WHITE;
    private List selectionListeners = new ArrayList(1);

    public ListSelection(EventList source) {
        this.source = source;
        this.barcode.add(0, this.deselected, source.size());
        source.addListEventListener(this.sourceListener);
        this.deselectedList = new DeselectedList(source);
        this.selectedList = new SelectedList(source);
    }

    public ListSelection(EventList source, int[] initialSelection) {
        this(source);
        this.select(initialSelection);
    }

    private int adjustIndex(int indexBefore, int changeType, int changeIndex) {
        if (indexBefore == -1) {
            return -1;
        }
        if (changeType == 0) {
            if (changeIndex < indexBefore) {
                return indexBefore - 1;
            }
            if (changeIndex == indexBefore) {
                return -1;
            }
            return indexBefore;
        }
        if (changeType == 1) {
            return indexBefore;
        }
        if (changeType == 2) {
            if (changeIndex <= indexBefore) {
                return indexBefore + 1;
            }
            return indexBefore;
        }
        throw new IllegalStateException();
    }

    public EventList getSelected() {
        return this.selectedList;
    }

    public EventList getDeselected() {
        return this.deselectedList;
    }

    public EventList getSource() {
        return this.source;
    }

    public void invertSelection() {
        if (this.selected == Barcode.BLACK) {
            this.selected = Barcode.WHITE;
            this.deselected = Barcode.BLACK;
        } else {
            this.selected = Barcode.BLACK;
            this.deselected = Barcode.WHITE;
        }
        this.anchorSelectionIndex = -1;
        this.leadSelectionIndex = -1;
        this.selectedList.updates().beginEvent();
        this.selectedList.updates().addDelete(0, this.barcode.colourSize(this.deselected) - 1);
        this.selectedList.updates().addInsert(0, this.barcode.colourSize(this.selected) - 1);
        this.selectedList.updates().commitEvent();
        this.deselectedList.updates().beginEvent();
        this.deselectedList.updates().addDelete(0, this.barcode.colourSize(this.selected) - 1);
        this.deselectedList.updates().addInsert(0, this.barcode.colourSize(this.deselected) - 1);
        this.deselectedList.updates().commitEvent();
        this.fireSelectionChanged(0, this.source.size() - 1);
    }

    public boolean isSelected(int sourceIndex) {
        if (sourceIndex < 0 || sourceIndex >= this.source.size()) {
            return false;
        }
        return this.barcode.getColourIndex(sourceIndex, this.selected) != -1;
    }

    public void deselect(int index) {
        this.deselect(index, index);
    }

    public void deselect(int start, int end) {
        if (start == -1 || end == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            int selectedIndex = this.getMaxSelectionIndex();
            if (selectedIndex >= start && selectedIndex <= end) {
                this.deselectAll();
            }
            return;
        }
        if (this.selectionMode == 1 && start > this.getMinSelectionIndex()) {
            end = Math.max(end, this.getMaxSelectionIndex());
        }
        this.anchorSelectionIndex = start;
        this.leadSelectionIndex = end;
        this.setSubRangeOfRange(false, start, end, -1, -1);
    }

    public void deselect(int[] indices) {
        ArrayList<DeselectedChange> deselections = new ArrayList<DeselectedChange>();
        int firstAffectedIndex = -1;
        int lastAffectedIndex = -1;
        this.selectedList.updates().beginEvent();
        int currentIndex = 0;
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNext() && currentIndex != indices.length) {
            Object value = i.next();
            if (i.getIndex() != indices[currentIndex]) continue;
            if (value == this.selected) {
                if (firstAffectedIndex == -1) {
                    firstAffectedIndex = i.getIndex();
                }
                lastAffectedIndex = i.getIndex();
                int selectedIndex = i.getColourIndex(this.selected);
                deselections.add(new DeselectedChange(2, i.set(this.deselected)));
                this.selectedList.updates().addDelete(selectedIndex);
            }
            ++currentIndex;
        }
        this.selectedList.updates().commitEvent();
        this.deselectedList.updates().beginEvent();
        for (int i2 = 0; i2 < deselections.size(); ++i2) {
            DeselectedChange change = (DeselectedChange)deselections.get(i2);
            change.fireChange();
        }
        this.deselectedList.updates().commitEvent();
        if (firstAffectedIndex > -1) {
            this.fireSelectionChanged(firstAffectedIndex, lastAffectedIndex);
        }
    }

    public void deselectAll() {
        int selectionChangeSize = this.barcode.colourSize(this.selected);
        if (selectionChangeSize == 0) {
            return;
        }
        int firstAffectedIndex = -1;
        int lastAffectedIndex = -1;
        this.deselectedList.updates().beginEvent();
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNextColour(this.selected)) {
            i.nextColour(this.selected);
            if (firstAffectedIndex == -1) {
                firstAffectedIndex = i.getIndex();
            }
            lastAffectedIndex = i.getIndex();
            this.deselectedList.updates().addInsert(i.getIndex());
        }
        this.barcode.clear();
        this.barcode.add(0, this.deselected, this.source.size());
        this.deselectedList.updates().commitEvent();
        this.selectedList.updates().beginEvent();
        this.selectedList.updates().addDelete(0, selectionChangeSize - 1);
        this.selectedList.updates().commitEvent();
        this.fireSelectionChanged(firstAffectedIndex, lastAffectedIndex);
    }

    public void select(int index) {
        this.select(index, index);
    }

    public void select(int start, int end) {
        if (start == -1 || end == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            this.setSelection(start);
            return;
        }
        if (this.selectionMode == 1) {
            boolean overlap = false;
            int minSelectedIndex = this.getMinSelectionIndex();
            int maxSelectedIndex = this.getMaxSelectionIndex();
            if (minSelectedIndex - 1 <= start && start <= maxSelectedIndex + 1) {
                overlap = true;
            }
            if (minSelectedIndex - 1 <= end && end <= maxSelectedIndex + 1) {
                overlap = true;
            }
            if (!overlap) {
                this.setSelection(start, end);
                return;
            }
        }
        this.anchorSelectionIndex = start;
        this.leadSelectionIndex = end;
        this.setSubRangeOfRange(true, start, end, -1, -1);
    }

    public void select(int[] indices) {
        ArrayList<DeselectedChange> selections = new ArrayList<DeselectedChange>();
        int firstAffectedIndex = -1;
        int lastAffectedIndex = -1;
        this.selectedList.updates().beginEvent();
        int currentIndex = 0;
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNext() && currentIndex != indices.length) {
            Object value = i.next();
            if (i.getIndex() != indices[currentIndex]) continue;
            if (value != this.selected) {
                if (firstAffectedIndex == -1) {
                    firstAffectedIndex = i.getIndex();
                }
                lastAffectedIndex = i.getIndex();
                int deselectedIndex = i.getColourIndex(this.deselected);
                selections.add(new DeselectedChange(0, deselectedIndex));
                this.selectedList.updates().addInsert(i.set(this.selected));
            }
            ++currentIndex;
        }
        this.selectedList.updates().commitEvent();
        this.deselectedList.updates().beginEvent();
        for (int i2 = 0; i2 < selections.size(); ++i2) {
            DeselectedChange change = (DeselectedChange)selections.get(i2);
            change.fireChange();
        }
        this.deselectedList.updates().commitEvent();
        if (firstAffectedIndex > -1) {
            this.fireSelectionChanged(firstAffectedIndex, lastAffectedIndex);
        }
    }

    public void selectAll() {
        int deselectionChangeSize = this.barcode.colourSize(this.deselected);
        if (deselectionChangeSize == 0) {
            return;
        }
        int firstAffectedIndex = -1;
        int lastAffectedIndex = -1;
        this.selectedList.updates().beginEvent();
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNextColour(this.deselected)) {
            i.nextColour(this.deselected);
            if (firstAffectedIndex == -1) {
                firstAffectedIndex = i.getIndex();
            }
            lastAffectedIndex = i.getIndex();
            this.selectedList.updates().addInsert(i.getIndex());
        }
        this.barcode.clear();
        this.barcode.add(0, this.selected, this.source.size());
        this.selectedList.updates().commitEvent();
        this.deselectedList.updates().beginEvent();
        this.deselectedList.updates().addDelete(0, deselectionChangeSize - 1);
        this.deselectedList.updates().commitEvent();
        this.fireSelectionChanged(firstAffectedIndex, lastAffectedIndex);
    }

    public void setSelection(int index) {
        this.setSelection(index, index);
    }

    public void setSelection(int start, int end) {
        if (start == -1 || end == -1) {
            this.deselectAll();
            return;
        }
        if (this.selectionMode == 0) {
            end = start;
        }
        this.anchorSelectionIndex = start;
        this.leadSelectionIndex = end;
        this.setSubRangeOfRange(true, start, end, this.getMinSelectionIndex(), this.getMaxSelectionIndex());
    }

    public void setSelection(int[] indices) {
        if (indices.length == 0) {
            this.deselectAll();
            return;
        }
        ArrayList<DeselectedChange> changes = new ArrayList<DeselectedChange>();
        int firstAffectedIndex = -1;
        int lastAffectedIndex = -1;
        this.selectedList.updates().beginEvent();
        int currentIndex = 0;
        BarcodeIterator i = this.barcode.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (i.getIndex() == indices[currentIndex]) {
                if (value != this.selected) {
                    if (firstAffectedIndex == -1) {
                        firstAffectedIndex = i.getIndex();
                    }
                    lastAffectedIndex = i.getIndex();
                    int deselectedIndex = i.getColourIndex(this.deselected);
                    changes.add(new DeselectedChange(0, deselectedIndex));
                    this.selectedList.updates().addInsert(i.set(this.selected));
                }
                if (currentIndex >= indices.length - 1) continue;
                ++currentIndex;
                continue;
            }
            if (value != this.selected) continue;
            if (firstAffectedIndex == -1) {
                firstAffectedIndex = i.getIndex();
            }
            lastAffectedIndex = i.getIndex();
            int selectedIndex = i.getColourIndex(this.selected);
            this.selectedList.updates().addDelete(selectedIndex);
            changes.add(new DeselectedChange(2, i.set(this.deselected)));
        }
        this.selectedList.updates().commitEvent();
        this.deselectedList.updates().beginEvent();
        for (int i2 = 0; i2 < changes.size(); ++i2) {
            DeselectedChange change = (DeselectedChange)changes.get(i2);
            change.fireChange();
        }
        this.deselectedList.updates().commitEvent();
        if (firstAffectedIndex > -1) {
            this.fireSelectionChanged(firstAffectedIndex, lastAffectedIndex);
        }
    }

    public int getAnchorSelectionIndex() {
        return this.anchorSelectionIndex;
    }

    public void setAnchorSelectionIndex(int anchorSelectionIndex) {
        this.anchorSelectionIndex = anchorSelectionIndex;
        if (anchorSelectionIndex == -1 || this.leadSelectionIndex == -1) {
            this.deselectAll();
        } else if (this.selectionMode == 0) {
            this.setSubRangeOfRange(true, anchorSelectionIndex, anchorSelectionIndex, this.getMinSelectionIndex(), this.getMaxSelectionIndex());
        } else if (this.selectionMode == 1) {
            this.setSubRangeOfRange(true, anchorSelectionIndex, this.leadSelectionIndex, this.getMinSelectionIndex(), this.getMaxSelectionIndex());
        } else {
            this.setSubRangeOfRange(true, anchorSelectionIndex, this.leadSelectionIndex, -1, -1);
        }
    }

    public int getLeadSelectionIndex() {
        return this.leadSelectionIndex;
    }

    public void setLeadSelectionIndex(int leadSelectionIndex) {
        int originalLeadIndex = this.leadSelectionIndex;
        this.leadSelectionIndex = leadSelectionIndex;
        if (leadSelectionIndex == -1 || this.anchorSelectionIndex == -1) {
            this.deselectAll();
        } else if (this.selectionMode == 0) {
            this.setSubRangeOfRange(true, leadSelectionIndex, leadSelectionIndex, this.getMinSelectionIndex(), this.getMaxSelectionIndex());
        } else if (this.selectionMode == 1) {
            this.setSubRangeOfRange(true, this.anchorSelectionIndex, leadSelectionIndex, this.getMinSelectionIndex(), this.getMaxSelectionIndex());
        } else {
            this.setSubRangeOfRange(true, this.anchorSelectionIndex, leadSelectionIndex, this.anchorSelectionIndex, originalLeadIndex);
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        this.setSelection(this.getMinSelectionIndex(), this.getMaxSelectionIndex());
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public int getMinSelectionIndex() {
        if (this.barcode.colourSize(this.selected) == 0) {
            return -1;
        }
        return this.barcode.getIndex(0, this.selected);
    }

    public int getMaxSelectionIndex() {
        if (this.barcode.colourSize(this.selected) == 0) {
            return -1;
        }
        return this.barcode.getIndex(this.barcode.colourSize(this.selected) - 1, this.selected);
    }

    private void setSubRangeOfRange(boolean select, int changeIndex0, int changeIndex1, int invertIndex0, int invertIndex1) {
        int i;
        if (changeIndex0 >= this.source.size() || changeIndex1 >= this.source.size() || (changeIndex0 == -1 || changeIndex1 == -1) && changeIndex0 != changeIndex1) {
            throw new IndexOutOfBoundsException("Invalid range for selection: " + changeIndex0 + "-" + changeIndex1 + ", list size is " + this.source.size());
        }
        if (invertIndex0 >= this.source.size() || invertIndex1 >= this.source.size() || (invertIndex0 == -1 || invertIndex1 == -1) && invertIndex0 != invertIndex1) {
            throw new IndexOutOfBoundsException("Invalid range for invert selection: " + invertIndex0 + "-" + invertIndex1 + ", list size is " + this.source.size());
        }
        if (changeIndex0 == -1 && changeIndex1 == -1) {
            if (invertIndex0 == -1 && invertIndex1 == -1) {
                return;
            }
            changeIndex0 = invertIndex0;
            changeIndex1 = invertIndex1;
            boolean bl = select = !select;
        }
        if (invertIndex0 == -1 && invertIndex1 == -1) {
            invertIndex0 = changeIndex0;
            invertIndex1 = changeIndex1;
        }
        int minChangeIndex = Math.min(changeIndex0, changeIndex1);
        int maxChangeIndex = Math.max(changeIndex0, changeIndex1);
        int minInvertIndex = Math.min(invertIndex0, invertIndex1);
        int maxInvertIndex = Math.max(invertIndex0, invertIndex1);
        int minUnionIndex = Math.min(minChangeIndex, minInvertIndex);
        int maxUnionIndex = Math.max(maxChangeIndex, maxInvertIndex);
        int minChangedIndex = maxUnionIndex + 1;
        int maxChangedIndex = minUnionIndex - 1;
        this.selectedList.updates().beginEvent();
        ArrayList<DeselectedChange> savedChanges = new ArrayList<DeselectedChange>();
        for (i = minUnionIndex; i <= maxUnionIndex; ++i) {
            boolean selectedAfter;
            int selectionIndex = this.barcode.getColourIndex(i, this.selected);
            boolean selectedBefore = selectionIndex != -1;
            boolean inChangeRange = i >= minChangeIndex && i <= maxChangeIndex;
            boolean bl = selectedAfter = inChangeRange == select;
            if (selectedBefore == selectedAfter) continue;
            if (i < minChangedIndex) {
                minChangedIndex = i;
            }
            if (i > maxChangedIndex) {
                maxChangedIndex = i;
            }
            if (selectedBefore) {
                this.barcode.set(i, this.deselected, 1);
                this.selectedList.updates().addDelete(selectionIndex);
                savedChanges.add(new DeselectedChange(2, i - selectionIndex));
                continue;
            }
            this.barcode.set(i, this.selected, 1);
            int newSelectionIndex = this.barcode.getColourIndex(i, this.selected);
            this.selectedList.updates().addInsert(newSelectionIndex);
            savedChanges.add(new DeselectedChange(0, i - newSelectionIndex));
        }
        this.selectedList.updates().commitEvent();
        this.deselectedList.updates().beginEvent();
        for (i = 0; i < savedChanges.size(); ++i) {
            DeselectedChange change = (DeselectedChange)savedChanges.get(i);
            change.fireChange();
        }
        savedChanges.clear();
        this.deselectedList.updates().commitEvent();
        if (minChangedIndex <= maxChangedIndex) {
            this.fireSelectionChanged(minChangedIndex, maxChangedIndex);
        }
    }

    public void addSelectionListener(Listener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(Listener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    private void fireSelectionChanged(int start, int end) {
        Iterator i = this.selectionListeners.iterator();
        while (i.hasNext()) {
            Listener listener = (Listener)i.next();
            listener.selectionChanged(start, end);
        }
    }

    public void dispose() {
        this.source.removeListEventListener(this.sourceListener);
        this.selectionListeners.clear();
    }

    private final class DeselectedList
    extends TransformedList {
        DeselectedList(EventList source) {
            super(source);
        }

        public int size() {
            return ListSelection.this.barcode.colourSize(ListSelection.this.deselected);
        }

        protected int getSourceIndex(int mutationIndex) {
            return ListSelection.this.barcode.getIndex(mutationIndex, ListSelection.this.deselected);
        }

        public void listChanged(ListEvent listChanges) {
        }

        public ListEventAssembler updates() {
            return this.updates;
        }

        public void dispose() {
        }
    }

    private final class SelectedList
    extends TransformedList {
        SelectedList(EventList source) {
            super(source);
        }

        public int size() {
            return ListSelection.this.barcode.colourSize(ListSelection.this.selected);
        }

        protected int getSourceIndex(int mutationIndex) {
            return ListSelection.this.barcode.getIndex(mutationIndex, ListSelection.this.selected);
        }

        public void listChanged(ListEvent listChanges) {
        }

        public ListEventAssembler updates() {
            return this.updates;
        }

        public void dispose() {
        }
    }

    private final class DeselectedChange {
        private int type = 0;
        private int index = 0;

        public DeselectedChange(int type, int index) {
            this.type = type;
            this.index = index;
        }

        public void fireChange() {
            ListSelection.this.deselectedList.updates().addChange(this.type, this.index);
        }
    }

    public static interface Listener {
        public void selectionChanged(int var1, int var2);
    }

    private class SourceListener
    implements ListEventListener {
        private SourceListener() {
        }

        public void listChanged(ListEvent listChanges) {
            int minSelectionIndexBefore = ListSelection.this.getMinSelectionIndex();
            int maxSelectionIndexBefore = ListSelection.this.getMaxSelectionIndex();
            if (listChanges.isReordering()) {
                ListSelection.this.selectedList.updates().beginEvent();
                int[] sourceReorderMap = listChanges.getReorderMap();
                int[] selectReorderMap = new int[ListSelection.this.barcode.colourSize(ListSelection.this.selected)];
                int[] deselectReorderMap = new int[ListSelection.this.barcode.colourSize(ListSelection.this.deselected)];
                Barcode previousBarcode = ListSelection.this.barcode;
                ListSelection.this.barcode = new Barcode();
                for (int c = 0; c < sourceReorderMap.length; ++c) {
                    int currentIndex;
                    int previousIndex;
                    Object flag = previousBarcode.get(sourceReorderMap[c]);
                    boolean wasSelected = flag != ListSelection.this.deselected;
                    ListSelection.this.barcode.add(c, flag, 1);
                    if (wasSelected) {
                        previousIndex = previousBarcode.getColourIndex(sourceReorderMap[c], ListSelection.this.selected);
                        currentIndex = ListSelection.this.barcode.getColourIndex(c, ListSelection.this.selected);
                        selectReorderMap[currentIndex] = previousIndex;
                        continue;
                    }
                    previousIndex = previousBarcode.getColourIndex(sourceReorderMap[c], ListSelection.this.deselected);
                    currentIndex = ListSelection.this.barcode.getColourIndex(c, ListSelection.this.deselected);
                    deselectReorderMap[currentIndex] = previousIndex;
                }
                ListSelection.this.anchorSelectionIndex = -1;
                ListSelection.this.leadSelectionIndex = -1;
                ListSelection.this.selectedList.updates().reorder(selectReorderMap);
                ListSelection.this.selectedList.updates().commitEvent();
                ListSelection.this.deselectedList.updates().beginEvent();
                ListSelection.this.deselectedList.updates().reorder(deselectReorderMap);
                ListSelection.this.deselectedList.updates().commitEvent();
            } else {
                ArrayList<DeselectedChange> savedChanges = new ArrayList<DeselectedChange>();
                ListSelection.this.selectedList.updates().beginEvent();
                while (listChanges.next()) {
                    int deselectedIndex;
                    boolean previouslySelected;
                    int index = listChanges.getIndex();
                    int changeType = listChanges.getType();
                    int previousSelectionIndex = ListSelection.this.barcode.getColourIndex(index, ListSelection.this.selected);
                    boolean bl = previouslySelected = previousSelectionIndex != -1;
                    if (changeType == 0) {
                        if (previouslySelected) {
                            ListSelection.this.barcode.remove(index, 1);
                            ListSelection.this.selectedList.updates().addDelete(previousSelectionIndex);
                        } else {
                            deselectedIndex = ListSelection.this.barcode.getColourIndex(index, ListSelection.this.deselected);
                            savedChanges.add(new DeselectedChange(0, deselectedIndex));
                            ListSelection.this.barcode.remove(index, 1);
                        }
                    } else if (changeType == 2) {
                        if (previouslySelected) {
                            if (ListSelection.this.selectionMode == 1 || ListSelection.this.selectionMode == 2) {
                                ListSelection.this.barcode.add(index, ListSelection.this.selected, 1);
                                ListSelection.this.selectedList.updates().addInsert(previousSelectionIndex);
                            } else {
                                ListSelection.this.barcode.add(index, ListSelection.this.deselected, 1);
                                deselectedIndex = ListSelection.this.barcode.getColourIndex(index, ListSelection.this.deselected);
                                savedChanges.add(new DeselectedChange(2, deselectedIndex));
                            }
                        } else {
                            ListSelection.this.barcode.add(index, ListSelection.this.deselected, 1);
                            deselectedIndex = ListSelection.this.barcode.getColourIndex(index, ListSelection.this.deselected);
                            savedChanges.add(new DeselectedChange(2, deselectedIndex));
                        }
                    } else if (changeType == 1) {
                        if (previouslySelected) {
                            ListSelection.this.selectedList.updates().addUpdate(previousSelectionIndex);
                        } else {
                            deselectedIndex = ListSelection.this.barcode.getColourIndex(index, ListSelection.this.deselected);
                            savedChanges.add(new DeselectedChange(1, deselectedIndex));
                        }
                    }
                    ListSelection.this.anchorSelectionIndex = ListSelection.this.adjustIndex(ListSelection.this.anchorSelectionIndex, changeType, index);
                    ListSelection.this.leadSelectionIndex = ListSelection.this.adjustIndex(ListSelection.this.leadSelectionIndex, changeType, index);
                }
                ListSelection.this.selectedList.updates().commitEvent();
                ListSelection.this.deselectedList.updates().beginEvent();
                for (int i = 0; i < savedChanges.size(); ++i) {
                    DeselectedChange change = (DeselectedChange)savedChanges.get(i);
                    change.fireChange();
                }
                savedChanges.clear();
                ListSelection.this.deselectedList.updates().commitEvent();
            }
            if (minSelectionIndexBefore != -1 && maxSelectionIndexBefore != -1) {
                int minSelectionIndexAfter = ListSelection.this.getMinSelectionIndex();
                int maxSelectionIndexAfter = ListSelection.this.getMaxSelectionIndex();
                int changeStart = minSelectionIndexBefore;
                int changeFinish = maxSelectionIndexBefore;
                if (minSelectionIndexAfter != -1 && minSelectionIndexAfter < changeStart) {
                    changeStart = minSelectionIndexAfter;
                }
                if (maxSelectionIndexAfter != -1 && maxSelectionIndexAfter > changeFinish) {
                    changeFinish = maxSelectionIndexAfter;
                }
                ListSelection.this.fireSelectionChanged(changeStart, changeFinish);
            }
        }
    }
}

