/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.CacheTestHelper;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.AgedNode;
import ca.odell.glazedlists.impl.adt.AgedNodeComparator;
import ca.odell.glazedlists.impl.adt.IndexedTree;
import ca.odell.glazedlists.impl.adt.IndexedTreeNode;
import ca.odell.glazedlists.impl.adt.SparseList;
import ca.odell.glazedlists.impl.adt.SparseListNode;
import ca.odell.glazedlists.util.concurrent.Lock;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;

public class CachingList
extends TransformedList {
    private IndexedTree cache;
    private SparseList indexTree;
    private int cacheHits;
    private int cacheMisses;
    private int currentSize = 0;
    private int maxSize = 0;
    private int lastKnownSize = 0;

    public CachingList(EventList source, int maxSize) {
        super(source);
        this.readWriteLock = new CacheLock(this.readWriteLock);
        this.maxSize = maxSize;
        this.cache = new IndexedTree(new AgedNodeComparator());
        this.indexTree = new SparseList();
        this.indexTree.addNulls(0, source.size());
        source.addListEventListener(this);
        this.lastKnownSize = source.size();
    }

    public final int size() {
        return this.source.size();
    }

    public final Object get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("cannot get from tree of size " + this.size() + " at " + index);
        }
        this.preFetch(index);
        return this.fetch(index, true);
    }

    protected final Object fetch(int index, boolean recordHitsOrMisses) {
        Object value = null;
        IndexedTreeNode cacheNode = (IndexedTreeNode)this.indexTree.get(index);
        if (cacheNode != null) {
            if (recordHitsOrMisses) {
                ++this.cacheHits;
            }
            AgedNode agedNode = (AgedNode)cacheNode.getValue();
            value = agedNode.getValue();
            cacheNode.removeFromTree(this.cache);
            SparseListNode indexNode = agedNode.getIndexNode();
            indexNode.setValue(this.cache.addByNode(agedNode));
        } else {
            if (recordHitsOrMisses) {
                ++this.cacheMisses;
            }
            if (this.currentSize >= this.maxSize) {
                IndexedTreeNode oldestInCache = this.cache.getNode(0);
                oldestInCache.removeFromTree(this.cache);
                AgedNode oldAgedNode = (AgedNode)oldestInCache.getValue();
                SparseListNode oldIndexNode = oldAgedNode.getIndexNode();
                this.indexTree.set(oldIndexNode.getIndex(), (Object)null);
                --this.currentSize;
            }
            value = this.source.get(index);
            this.indexTree.set(index, Boolean.TRUE);
            SparseListNode indexNode = this.indexTree.getNode(index);
            AgedNode agedNode = new AgedNode(indexNode, value);
            indexNode.setValue(this.cache.addByNode(agedNode));
            ++this.currentSize;
        }
        return value;
    }

    protected void preFetch(int index) {
    }

    protected boolean isWritable() {
        return true;
    }

    public final int getCacheHits() {
        return this.cacheHits;
    }

    public final int getCacheMisses() {
        return this.cacheMisses;
    }

    public final float getCacheHitRatio() {
        if (this.cacheHits + this.cacheMisses == 0) {
            return 0.0f;
        }
        return (float)this.cacheHits / (float)(this.cacheHits + this.cacheMisses);
    }

    public final void listChanged(ListEvent listChanges) {
        this.updates.beginEvent();
        while (listChanges.next()) {
            int index = listChanges.getIndex();
            int changeType = listChanges.getType();
            IndexedTreeNode cacheNode = null;
            if (index < this.lastKnownSize) {
                cacheNode = (IndexedTreeNode)this.indexTree.get(index);
            }
            if (changeType == 2) {
                this.indexTree.add(index, (Object)null);
            } else if (changeType == 0) {
                if (cacheNode != null) {
                    cacheNode.removeFromTree(this.cache);
                    --this.currentSize;
                }
                this.indexTree.remove(index);
            } else if (changeType == 1 && cacheNode != null) {
                cacheNode.removeFromTree(this.cache);
                --this.currentSize;
            }
            this.updates.addChange(changeType, index);
        }
        this.lastKnownSize = this.source.size();
        this.updates.commitEvent();
    }

    public static void main(String[] args) {
        int argsLength = args.length;
        int listSize = -1;
        int cacheSize = -1;
        int waitDuration = -1;
        CacheTestHelper testHelper = null;
        if (argsLength == 2) {
            try {
                listSize = Integer.parseInt(args[0]);
                waitDuration = Integer.parseInt(args[1]);
                testHelper = new CacheTestHelper(listSize, waitDuration);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("CachingList expects integer arguments.");
            }
        } else if (argsLength == 3) {
            try {
                listSize = Integer.parseInt(args[0]);
                cacheSize = Integer.parseInt(args[1]);
                waitDuration = Integer.parseInt(args[2]);
                testHelper = new CacheTestHelper(listSize, cacheSize, waitDuration);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("CachingList expects integer arguments.");
            }
        } else {
            System.out.println("'CachingList' Usage:");
            System.out.println("CachingList <sourceListSize> <waitDuration>");
            System.out.println("OR");
            System.out.println("CachingList <sourceListSize> <cacheSize> <waitDuration>");
            System.exit(1);
        }
        testHelper.runTests();
    }

    private class CacheLock
    implements ReadWriteLock {
        private ReadWriteLock sourceLock;

        public CacheLock(ReadWriteLock sourceLock) {
            this.sourceLock = sourceLock;
        }

        public Lock readLock() {
            return this.writeLock();
        }

        public Lock writeLock() {
            return this.sourceLock.writeLock();
        }
    }
}

