/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.util.concurrent.J2SE12ReadWriteLock;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class BasicEventList
extends AbstractEventList {
    private List data;

    public BasicEventList() {
        this(new J2SE12ReadWriteLock());
    }

    public BasicEventList(ReadWriteLock readWriteLock) {
        super(null);
        this.data = new ArrayList();
        this.readWriteLock = readWriteLock;
    }

    public BasicEventList(List list) {
        super(null);
        this.data = list;
        this.readWriteLock = new J2SE12ReadWriteLock();
    }

    public void add(int index, Object element) {
        this.updates.beginEvent();
        this.updates.addInsert(index);
        this.data.add(index, element);
        this.updates.commitEvent();
    }

    public boolean add(Object element) {
        this.updates.beginEvent();
        this.updates.addInsert(this.size());
        boolean result = this.data.add(element);
        this.updates.commitEvent();
        return result;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public boolean addAll(int index, Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        this.updates.beginEvent();
        this.updates.addInsert(index, index + collection.size() - 1);
        boolean result = this.data.addAll(index, collection);
        this.updates.commitEvent();
        return result;
    }

    public boolean addAll(Object[] objects) {
        return this.addAll(this.size(), objects);
    }

    public boolean addAll(int index, Object[] objects) {
        if (objects.length == 0) {
            return false;
        }
        this.updates.beginEvent();
        this.updates.addInsert(index, index + objects.length - 1);
        boolean overallResult = true;
        boolean elementResult = true;
        for (int i = 0; i < objects.length; ++i) {
            elementResult = this.data.add(objects[i]);
            overallResult = overallResult && elementResult;
        }
        this.updates.commitEvent();
        return overallResult;
    }

    public Object remove(int index) {
        this.updates.beginEvent();
        this.updates.addDelete(index);
        Object removed = this.data.remove(index);
        this.updates.commitEvent();
        return removed;
    }

    public boolean remove(Object element) {
        int index = this.data.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.updates.beginEvent();
        this.updates.addDelete(0, this.size() - 1);
        this.data.clear();
        this.updates.commitEvent();
    }

    public Object set(int index, Object element) {
        this.updates.beginEvent();
        this.updates.addUpdate(index);
        Object previous = this.data.set(index, element);
        this.updates.commitEvent();
        return previous;
    }

    public Object get(int index) {
        return this.data.get(index);
    }

    public int size() {
        return this.data.size();
    }

    public boolean removeAll(Collection collection) {
        boolean changed = false;
        this.updates.beginEvent();
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            int index = -1;
            while ((index = this.indexOf(value)) != -1) {
                this.updates.addDelete(index);
                this.data.remove(index);
                changed = true;
            }
        }
        this.updates.commitEvent();
        return changed;
    }

    public boolean retainAll(Collection collection) {
        boolean changed = false;
        this.updates.beginEvent();
        int index = 0;
        while (index < this.data.size()) {
            if (collection.contains(this.data.get(index))) {
                ++index;
                continue;
            }
            this.updates.addDelete(index);
            this.data.remove(index);
            changed = true;
        }
        this.updates.commitEvent();
        return changed;
    }
}

