/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.impl.EventListIterator;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.SimpleIterator;
import ca.odell.glazedlists.impl.SubEventList;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractEventList
implements EventList {
    protected ListEventAssembler updates = null;
    protected ReadWriteLock readWriteLock = null;
    protected ListEventPublisher publisher = null;

    protected AbstractEventList(ListEventPublisher publisher) {
        if (publisher == null) {
            publisher = new ListEventPublisher();
        }
        this.publisher = publisher;
        this.updates = new ListEventAssembler(this, publisher);
    }

    public ListEventPublisher getPublisher() {
        return this.publisher;
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public void addListEventListener(ListEventListener listChangeListener) {
        this.updates.addListEventListener(listChangeListener);
    }

    public void removeListEventListener(ListEventListener listChangeListener) {
        this.updates.removeListEventListener(listChangeListener);
    }

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (!GlazedListsImpl.equal(object, i.next())) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return this.size() == 0 ? Collections.EMPTY_LIST.iterator() : new SimpleIterator(this);
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int index = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            array[index] = i.next();
            ++index;
        }
        return array;
    }

    public Object[] toArray(Object[] array) {
        if (array.length < this.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size());
        } else if (array.length > this.size()) {
            array[this.size()] = null;
        }
        int index = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            array[index] = i.next();
            ++index;
        }
        return array;
    }

    public boolean add(Object value) {
        this.add(this.size(), value);
        return true;
    }

    public boolean remove(Object toRemove) {
        int index = this.indexOf(toRemove);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public boolean containsAll(Collection values) {
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Object a = i.next();
            if (this.contains(a)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection values) {
        return this.addAll(this.size(), values);
    }

    public boolean addAll(int index, Collection values) {
        if (values.size() == 0) {
            return false;
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Cannot add at " + index + " on list of size " + this.size());
        }
        int count = 0;
        Iterator i = values.iterator();
        while (i.hasNext()) {
            this.add(index + count, i.next());
            ++count;
        }
        return true;
    }

    public boolean removeAll(Collection values) {
        boolean overallChanged = false;
        Iterator i = values.iterator();
        while (i.hasNext()) {
            boolean removeChanged = this.remove(i.next());
            if (!removeChanged) continue;
            overallChanged = true;
        }
        return overallChanged;
    }

    public boolean retainAll(Collection values) {
        boolean changed = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (values.contains(i.next())) continue;
            i.remove();
            changed = true;
        }
        return changed;
    }

    public void clear() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List otherList = (List)object;
        if (otherList.size() != this.size()) {
            return false;
        }
        Iterator iterA = this.iterator();
        Iterator iterB = otherList.iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            if (GlazedListsImpl.equal(iterA.next(), iterB.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object a = i.next();
            hashCode = 31 * hashCode + (a == null ? 0 : a.hashCode());
        }
        return hashCode;
    }

    public abstract Object get(int var1);

    public Object set(int index, Object value) {
        throw new IllegalStateException("this list does not support set()");
    }

    public void add(int index, Object value) {
        throw new IllegalStateException("this list does not support add()");
    }

    public Object remove(int index) {
        throw new IllegalStateException("this list does not support remove()");
    }

    public int indexOf(Object object) {
        int index = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (GlazedListsImpl.equal(object, i.next())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!GlazedListsImpl.equal(object, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new EventListIterator(this, index);
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubEventList(this, fromIndex, toIndex, true);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        Iterator i = this.iterator();
        while (i.hasNext()) {
            result.append(String.valueOf(i.next()));
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }
}

