/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.util;

import java.util.Formatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.browsermob.proxy.util.StandardFormatter;

public class Log {
    protected Logger logger;
    private String className;

    public Log() {
        Exception e = new Exception();
        this.className = e.getStackTrace()[1].getClassName();
        this.logger = Logger.getLogger(this.className);
    }

    public Log(Class clazz) {
        this.className = clazz.getName();
        this.logger = Logger.getLogger(this.className);
    }

    public void severe(String msg, Throwable e) {
        this.log(Level.SEVERE, msg, e);
    }

    public void severe(String msg, Object ... args) {
        this.log(Level.SEVERE, msg, args);
    }

    public void severe(String msg, Throwable e, Object ... args) {
        this.log(Level.SEVERE, msg, e, args);
    }

    public RuntimeException severeAndRethrow(String msg, Throwable e, Object ... args) {
        this.log(Level.SEVERE, msg, e, args);
        return new RuntimeException(new Formatter().format(msg, args).toString());
    }

    public void warn(String msg, Throwable e) {
        this.log(Level.WARNING, msg, e);
    }

    public void warn(String msg, Object ... args) {
        this.log(Level.WARNING, msg, args);
    }

    public void warn(String msg, Throwable e, Object ... args) {
        this.log(Level.WARNING, msg, e, args);
    }

    public void info(String msg, Throwable e) {
        this.log(Level.INFO, msg, e);
    }

    public void info(String msg, Object ... args) {
        this.log(Level.INFO, msg, args);
    }

    public void info(String msg, Throwable e, Object ... args) {
        this.log(Level.INFO, msg, e, args);
    }

    public void fine(String msg, Throwable e) {
        this.log(Level.FINE, msg, e);
    }

    public void fine(String msg, Object ... args) {
        this.log(Level.FINE, msg, args);
    }

    public void fine(String msg, Throwable e, Object ... args) {
        this.log(Level.FINE, msg, e, args);
    }

    private void log(Level level, String msg, Throwable e) {
        this.logger.log(level, msg, e);
    }

    private void log(Level level, String msg, Object ... args) {
        this.logger.log(level, msg, args);
    }

    private void log(Level level, String msg, Throwable e, Object ... args) {
        LogRecord lr = new LogRecord(level, msg);
        lr.setThrown(e);
        lr.setParameters(args);
        lr.setSourceMethodName("");
        lr.setSourceClassName(this.className);
        lr.setLoggerName(this.className);
        this.logger.log(lr);
    }

    static {
        Handler[] handlers;
        Logger logger = Logger.getLogger("");
        for (Handler handler : handlers = logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new StandardFormatter());
        handler.setLevel(Level.FINE);
        logger.addHandler(handler);
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
    }
}

