/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Date;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.browsermob.proxy.http.RequestInfo;
import org.browsermob.proxy.http.SimulatedInputStream;
import org.browsermob.proxy.http.SimulatedOutputStream;
import org.browsermob.proxy.http.SimulatedSocket;

public class SimulatedSSLSocket
extends SSLSocket {
    private SSLSocket socket;
    private long downstreamKbps;
    private long upstreamKbps;
    private long latency;
    private Date handshakeStart;
    private RequestInfo requestInfo;

    public SimulatedSSLSocket(SSLSocket socket, long downstreamKbps, long upstreamKbps, long latency) {
        this.socket = SimulatedSocket.configure(socket);
        this.downstreamKbps = downstreamKbps;
        this.upstreamKbps = upstreamKbps;
        this.latency = latency;
        this.addHandshakeCompletedListener(new HandshakeCompletedListener(){

            @Override
            public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                if (SimulatedSSLSocket.this.requestInfo != null) {
                    SimulatedSSLSocket.this.requestInfo.ssl(SimulatedSSLSocket.this.handshakeStart, new Date());
                }
            }
        });
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socket.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.socket.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] strings) {
        this.socket.setEnabledCipherSuites(strings);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.socket.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.socket.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] strings) {
        this.socket.setEnabledProtocols(strings);
    }

    @Override
    public SSLSession getSession() {
        return this.socket.getSession();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.socket.addHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.socket.removeHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public void startHandshake() throws IOException {
        this.socket.startHandshake();
    }

    @Override
    public void setUseClientMode(boolean b) {
        this.socket.setUseClientMode(b);
    }

    @Override
    public boolean getUseClientMode() {
        return this.socket.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean b) {
        this.socket.setNeedClientAuth(b);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.socket.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean b) {
        this.socket.setWantClientAuth(b);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.socket.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean b) {
        this.socket.setEnableSessionCreation(b);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.socket.getEnableSessionCreation();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.socket.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters sslParameters) {
        this.socket.setSSLParameters(sslParameters);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        Date start = new Date();
        this.socket.connect(endpoint);
        Date end = new Date();
        RequestInfo.get().connect(start, end);
        this.handshakeStart = new Date();
        this.requestInfo = RequestInfo.get();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        Date start = new Date();
        this.socket.connect(endpoint, timeout);
        Date end = new Date();
        RequestInfo.get().connect(start, end);
        this.handshakeStart = new Date();
        this.requestInfo = RequestInfo.get();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.socket.bind(bindpoint);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new SimulatedInputStream(this.socket.getInputStream(), this.downstreamKbps, this.latency);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new SimulatedOutputStream(this.socket.getOutputStream(), this.upstreamKbps, this.latency);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.socket.sendUrgentData(data);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.socket.toString();
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.socket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.socket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }
}

