/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.http;

import java.io.IOException;
import java.io.OutputStream;

public class SimulatedOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private long latency;
    private long bytesPerSecond;
    private boolean roundUp;

    public SimulatedOutputStream(OutputStream outputStream, long kiloBitsPerSecond, long latency) {
        this.outputStream = outputStream;
        this.latency = latency;
        this.bytesPerSecond = kiloBitsPerSecond * 1000L / 8L;
    }

    @Override
    public void write(int b) throws IOException {
        long start = System.currentTimeMillis();
        this.outputStream.write(b);
        long end = System.currentTimeMillis();
        this.simulate(1, end - start);
    }

    @Override
    public void write(byte[] b) throws IOException {
        long start = System.currentTimeMillis();
        this.outputStream.write(b);
        long end = System.currentTimeMillis();
        this.simulate(b.length, end - start);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long start = System.currentTimeMillis();
        this.outputStream.write(b, off, len);
        long end = System.currentTimeMillis();
        this.simulate(len, end - start);
    }

    private void simulate(int bytes, long timeTaken) {
        if (this.bytesPerSecond <= 0L) {
            return;
        }
        double d = (double)bytes / (double)this.bytesPerSecond * 1000.0;
        long expectedTime = (long)(this.roundUp ? Math.ceil(d) : Math.floor(d)) + this.latency;
        this.roundUp = !this.roundUp;
        long diff = expectedTime - timeTaken;
        if (diff > 0L) {
            try {
                Thread.sleep(diff);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

