/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectTimeoutException;
import org.browsermob.proxy.FirefoxErrorContent;
import org.browsermob.proxy.http.BadURIException;
import org.browsermob.proxy.http.BrowserMobHttpClient;
import org.browsermob.proxy.http.BrowserMobHttpRequest;
import org.browsermob.proxy.http.BrowserMobHttpResponse;
import org.browsermob.proxy.http.RequestCallback;
import org.browsermob.proxy.jetty.http.EOFException;
import org.browsermob.proxy.jetty.http.HttpException;
import org.browsermob.proxy.jetty.http.HttpListener;
import org.browsermob.proxy.jetty.http.HttpRequest;
import org.browsermob.proxy.jetty.http.HttpResponse;
import org.browsermob.proxy.jetty.http.HttpServer;
import org.browsermob.proxy.jetty.http.HttpTunnel;
import org.browsermob.proxy.jetty.http.SocketListener;
import org.browsermob.proxy.jetty.jetty.Server;
import org.browsermob.proxy.jetty.util.InetAddrPort;
import org.browsermob.proxy.jetty.util.URI;
import org.browsermob.proxy.selenium.SeleniumProxyHandler;
import org.browsermob.proxy.util.Log;

public class BrowserMobProxyHandler
extends SeleniumProxyHandler {
    private static final Log LOG = new Log();
    private static final int HEADER_BUFFER_DEFAULT = 2;
    private Server jettyServer;
    private int headerBufferMultiplier = 2;
    private BrowserMobHttpClient httpClient;
    protected final Set<SeleniumProxyHandler.SslRelay> sslRelays = new HashSet<SeleniumProxyHandler.SslRelay>();

    public BrowserMobProxyHandler() {
        super(true, "", "", false, false);
        this.setShutdownLock(new Object());
        this.setTunnelTimeoutMs(300000);
    }

    @Override
    public void handleConnect(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        String altHost;
        String original;
        URI uri = request.getURI();
        String host = original = uri.toString();
        String port = null;
        int colon = original.indexOf(58);
        if (colon != -1) {
            host = original.substring(0, colon);
            port = original.substring(colon + 1);
        }
        if ((altHost = this.httpClient.remappedHost(host)) != null) {
            if (port != null) {
                uri.setURI(altHost + ":" + port);
            } else {
                uri.setURI(altHost);
            }
        }
        super.handleConnect(pathInContext, pathParams, request, response);
    }

    @Override
    protected void wireUpSslWithCyberVilliansCA(String host, SeleniumProxyHandler.SslRelay listener) {
        List<String> originalHosts = this.httpClient.originalHosts(host);
        if (originalHosts != null && !originalHosts.isEmpty()) {
            if (originalHosts.size() == 1) {
                host = originalHosts.get(0);
            } else {
                String first = originalHosts.get(0);
                host = "*" + first.substring(first.indexOf(46));
            }
        }
        super.wireUpSslWithCyberVilliansCA(host, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SeleniumProxyHandler.SslRelay getSslRelayOrCreateNew(URI uri, InetAddrPort addrPort, HttpServer server) throws Exception {
        SeleniumProxyHandler.SslRelay relay = super.getSslRelayOrCreateNew(uri, addrPort, server);
        relay.setNukeDirOrFile(null);
        Set<SeleniumProxyHandler.SslRelay> set = this.sslRelays;
        synchronized (set) {
            this.sslRelays.add(relay);
        }
        if (!relay.isStarted()) {
            server.addListener(relay);
            this.startRelayWithPortTollerance(server, relay, 1);
        }
        return relay;
    }

    private void startRelayWithPortTollerance(HttpServer server, SeleniumProxyHandler.SslRelay relay, int tries) throws Exception {
        if (tries >= 5) {
            throw new BindException("Unable to bind to several ports, most recently " + relay.getPort() + ". Giving up");
        }
        try {
            if (!server.isStarted()) {
                throw new RuntimeException("Can't start SslRelay: server is not started (perhaps it was just shut down?)");
            }
            relay.start();
        }
        catch (BindException e) {
            LOG.info("Unable to bind to port %d, going to try port %d now", relay.getPort(), relay.getPort() + 1);
            relay.setPort(relay.getPort() + 1);
            this.startRelayWithPortTollerance(server, relay, tries + 1);
        }
    }

    @Override
    protected HttpTunnel newHttpTunnel(HttpRequest httpRequest, HttpResponse httpResponse, InetAddress inetAddress, int i, int i1) throws IOException {
        this.adjustListenerBuffers();
        return super.newHttpTunnel(httpRequest, httpResponse, inetAddress, i, i1);
    }

    @Override
    protected long proxyPlainTextRequest(final URL url, String pathInContext, String pathParams, HttpRequest request, final HttpResponse response) throws IOException {
        try {
            String urlStr = url.toString();
            if (urlStr.startsWith("http://localhost") || urlStr.contains("/selenium-server/")) {
                return super.proxyPlainTextRequest(url, pathInContext, pathParams, request, response);
            }
            if (urlStr.startsWith("https://sb-ssl.google.com:443/safebrowsing") || urlStr.startsWith("http://en-us.fxfeeds.mozilla.com/en-US/firefox/headlines.xml") || urlStr.startsWith("http://fxfeeds.mozilla.com/firefox/headlines.xml") || urlStr.startsWith("http://fxfeeds.mozilla.com/en-US/firefox/headlines.xml") || urlStr.startsWith("http://newsrss.bbc.co.uk/rss/newsonline_world_edition/front_page/rss.xml")) {
                request.setHandled(true);
                return -1L;
            }
            if (this.httpClient == null) {
                request.setHandled(true);
                return -1L;
            }
            BrowserMobHttpRequest httpReq = null;
            if ("GET".equals(request.getMethod())) {
                httpReq = this.httpClient.newGet(urlStr);
            } else if ("POST".equals(request.getMethod())) {
                httpReq = this.httpClient.newPost(urlStr);
            } else if ("PUT".equals(request.getMethod())) {
                httpReq = this.httpClient.newPut(urlStr);
            } else if ("DELETE".equals(request.getMethod())) {
                httpReq = this.httpClient.newDelete(urlStr);
            } else if ("OPTIONS".equals(request.getMethod())) {
                httpReq = this.httpClient.newOptions(urlStr);
            } else if ("HEAD".equals(request.getMethod())) {
                httpReq = this.httpClient.newHead(urlStr);
            } else {
                LOG.warn("Unexpected request method %s, giving up", request.getMethod());
                request.setHandled(true);
                return -1L;
            }
            boolean isGet = "GET".equals(request.getMethod());
            boolean hasContent = false;
            Enumeration enm = request.getFieldNames();
            long contentLength = 0L;
            while (enm.hasMoreElements()) {
                String hdr = (String)enm.nextElement();
                if (!isGet && "Content-Type".equals(hdr)) {
                    hasContent = true;
                }
                if (!isGet && "Content-Length".equals(hdr)) {
                    contentLength = Long.parseLong(request.getField(hdr));
                    continue;
                }
                Enumeration vals = request.getFieldValues(hdr);
                while (vals.hasMoreElements()) {
                    String val = (String)vals.nextElement();
                    if (val == null) continue;
                    if ("User-Agent".equals(hdr)) {
                        val = BrowserMobProxyHandler.updateUserAgent(val);
                    }
                    if ("Referer".equals(hdr) && -1 != val.indexOf("/selenium-server/")) continue;
                    if (!isGet && "Content-Length".equals(hdr) && Integer.parseInt(val) > 0) {
                        hasContent = true;
                    }
                    httpReq.addRequestHeader(hdr, val);
                }
            }
            try {
                InputStream in = request.getInputStream();
                if (hasContent) {
                    httpReq.setRequestInputStream(in, contentLength);
                }
            }
            catch (Exception e) {
                LOG.fine(e.getMessage(), e);
            }
            httpReq.setOutputStream(response.getOutputStream());
            httpReq.setRequestCallback(new RequestCallback(){

                @Override
                public void handleStatusLine(StatusLine statusLine) {
                    response.setStatus(statusLine.getStatusCode());
                    response.setReason(statusLine.getReasonPhrase());
                }

                @Override
                public void handleHeaders(Header[] headers) {
                    for (Header header : headers) {
                        if (!this.reportHeader(header)) continue;
                        response.addField(header.getName(), header.getValue());
                    }
                }

                @Override
                public boolean reportHeader(Header header) {
                    return !BrowserMobProxyHandler.this._DontProxyHeaders.containsKey(header.getName()) && !BrowserMobProxyHandler.this._ProxyAuthHeaders.containsKey(header.getName());
                }

                @Override
                public void reportError(Exception e) {
                    BrowserMobProxyHandler.reportError(e, url, response);
                }
            });
            BrowserMobHttpResponse httpRes = httpReq.execute();
            request.setHandled(true);
            return httpRes.getEntry().getResponse().getBodySize();
        }
        catch (BadURIException e) {
            LOG.info(e.getMessage(), new Object[0]);
            BrowserMobProxyHandler.reportError(e, url, response);
            return -1L;
        }
        catch (Exception e) {
            LOG.info("Exception while proxying " + url, e);
            BrowserMobProxyHandler.reportError(e, url, response);
            return -1L;
        }
    }

    private static void reportError(Exception e, URL url, HttpResponse response) {
        FirefoxErrorContent error = FirefoxErrorContent.GENERIC;
        if (e instanceof UnknownHostException) {
            error = FirefoxErrorContent.DNS_NOT_FOUND;
        } else if (e instanceof ConnectException) {
            error = FirefoxErrorContent.CONN_FAILURE;
        } else if (e instanceof ConnectTimeoutException) {
            error = FirefoxErrorContent.NET_TIMEOUT;
        } else if (e instanceof NoHttpResponseException) {
            error = FirefoxErrorContent.NET_RESET;
        } else if (e instanceof EOFException) {
            error = FirefoxErrorContent.NET_INTERRUPT;
        } else if (e instanceof IllegalArgumentException && e.getMessage().startsWith("Host name may not be null")) {
            error = FirefoxErrorContent.DNS_NOT_FOUND;
        } else if (e instanceof BadURIException) {
            error = FirefoxErrorContent.MALFORMED_URI;
        }
        String shortDesc = String.format(error.getShortDesc(), url.getHost());
        String text = String.format("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <title>Problem loading page</title>\n    <link rel=\"stylesheet\" href=\"chrome://global/skin/netError.css\" type=\"text/css\" media=\"all\" />\n    <link rel=\"icon\" type=\"image/png\" id=\"favicon\" href=\"chrome://global/skin/icons/warning-16.png\"/>\n  </head>\n\n  <body>\n\n    <!-- PAGE CONTAINER (for styling purposes only) -->\n    <div id=\"errorPageContainer\">\n    \n      <!-- Error Title -->\n      <div id=\"errorTitle\">\n        <h1 id=\"errorTitleText\">%s</h1>\n      </div>\n      \n      <!-- LONG CONTENT (the section most likely to require scrolling) -->\n      <div id=\"errorLongContent\">\n      \n        <!-- Short Description -->\n        <div id=\"errorShortDesc\">\n          <p id=\"errorShortDescText\" style=\"white-space: inherit\">\n              %s\n          </p>\n        </div>\n\n        <!-- Long Description (Note: See netError.dtd for used XHTML tags) -->\n        <div id=\"errorLongDesc\">\n           %s\n        </div>\n      </div>\n\n      <!-- Retry Button -->\n      <button id=\"errorTryAgain\">Try Again</button>\n\n    </div>\n\n  </body>\n</html>", error.getTitle(), shortDesc, error.getLongDesc());
        try {
            response.setStatus(502);
            response.setContentLength(text.length());
            response.getOutputStream().write(text.getBytes());
        }
        catch (IOException e1) {
            LOG.warn("IOException while trying to report an HTTP error", new Object[0]);
        }
    }

    private static String updateUserAgent(String ua) {
        int start = ua.indexOf(")");
        if (start > -1) {
            ua = ua.substring(0, start) + "; BrowserMob RBU" + ua.substring(start);
        }
        return ua;
    }

    public void autoBasicAuthorization(String domain, String username, String password) {
        this.httpClient.autoBasicAuthorization(domain, username, password);
    }

    public void rewriteUrl(String match, String replace) {
        this.httpClient.rewriteUrl(match, replace);
    }

    public void remapHost(String source, String target) {
        this.httpClient.remapHost(source, target);
    }

    public void setJettyServer(Server jettyServer) {
        this.jettyServer = jettyServer;
    }

    public void adjustListenerBuffers(int headerBufferMultiplier) {
        if (headerBufferMultiplier > 10) {
            headerBufferMultiplier = 10;
        }
        this.headerBufferMultiplier = headerBufferMultiplier;
        this.adjustListenerBuffers();
    }

    public void resetListenerBuffers() {
        this.headerBufferMultiplier = 2;
        this.adjustListenerBuffers();
    }

    public void adjustListenerBuffers() {
        HttpListener[] listeners;
        for (HttpListener listener : listeners = this.jettyServer.getListeners()) {
            if (!(listener instanceof SocketListener)) continue;
            SocketListener sl = (SocketListener)listener;
            if (sl.getBufferReserve() != 512 * this.headerBufferMultiplier) {
                sl.setBufferReserve(512 * this.headerBufferMultiplier);
            }
            if (sl.getBufferSize() == 8192 * this.headerBufferMultiplier) continue;
            sl.setBufferSize(8192 * this.headerBufferMultiplier);
        }
    }

    public void setHttpClient(BrowserMobHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Set<SeleniumProxyHandler.SslRelay> set = this.sslRelays;
        synchronized (set) {
            for (SeleniumProxyHandler.SslRelay relay : this.sslRelays) {
                if (relay.getHttpServer() == null || !relay.isStarted()) continue;
                relay.getHttpServer().removeListener(relay);
            }
            this.sslRelays.clear();
        }
    }
}

