/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.unmodifiable;

import aQute.bnd.unmodifiable.ImmutableIterator;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class ImmutableSet<E>
extends AbstractSet<E>
implements Set<E>,
Serializable {
    static final ImmutableSet<?> EMPTY = new ImmutableSet(new Object[0]);
    final Object[] elements;
    final transient short[] hash_bucket;
    private static final long serialVersionUID = 1L;

    ImmutableSet(Object ... elements) {
        this.elements = elements;
        this.hash_bucket = ImmutableSet.hash(elements);
    }

    private static short[] hash(Object[] elements) {
        int length = elements.length;
        if (length == 0) {
            return new short[1];
        }
        if (length >= 65536) {
            throw new IllegalArgumentException("set too large: " + length);
        }
        short[] hash_bucket = new short[length * 2];
        int slot = 0;
        while (slot < length) {
            Object e = elements[slot];
            int hash = -1 - ImmutableSet.linear_probe(elements, hash_bucket, e);
            if (hash < 0) {
                throw new IllegalArgumentException("duplicate element: " + e);
            }
            hash_bucket[hash] = (short)(++slot);
        }
        return hash_bucket;
    }

    private static int linear_probe(Object[] elements, short[] hash_bucket, Object e) {
        int length = hash_bucket.length;
        int hash = (e.hashCode() & Integer.MAX_VALUE) % length;
        int index;
        while ((index = Short.toUnsignedInt(hash_bucket[hash]) - 1) >= 0) {
            if (elements[index].equals(e)) {
                return index;
            }
            hash = (hash + 1) % length;
        }
        return -1 - hash;
    }

    private int linear_probe(Object e) {
        return ImmutableSet.linear_probe(this.elements, this.hash_bucket, e);
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableIterator(this.elements);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1297);
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            return this.linear_probe(o) >= 0;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.elements.length, Object[].class);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int length = this.elements.length;
        if (length > array.length) {
            return Arrays.copyOf(this.elements, length, array.getClass());
        }
        System.arraycopy(this.elements, 0, array, 0, length);
        if (length < array.length) {
            array[length] = null;
        }
        return array;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        Object[] elements = this.elements;
        int end = elements.length;
        for (int index = 0; index < end; ++index) {
            action.accept(elements[index]);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set other = (Set)o;
        if (this.elements.length != other.size()) {
            return false;
        }
        try {
            for (Object element : this.elements) {
                if (other.contains(element)) continue;
                return false;
            }
        }
        catch (ClassCastException checkedSet) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Object element : this.elements) {
            hashCode += element.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("proxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static final class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Object[] data;

        SerializationProxy(ImmutableSet<?> set) {
            this.data = set.elements;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            Object[] local = this.data;
            int length = local.length;
            oos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                oos.writeObject(local[i]);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            int length = ois.readInt();
            if (length < 0) {
                throw new InvalidObjectException("negative length");
            }
            Object[] local = new Object[length];
            for (int i = 0; i < length; ++i) {
                local[i] = ois.readObject();
            }
            this.data = local;
        }

        private Object readResolve() throws InvalidObjectException {
            try {
                Object[] local = this.data;
                if (local.length == 0) {
                    return EMPTY;
                }
                return new ImmutableSet(local);
            }
            catch (RuntimeException e) {
                InvalidObjectException ioe = new InvalidObjectException("invalid");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }
}

