/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.utils;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.suppliers.Supplier;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import javax.lang.model.element.Modifier;

public enum ThirdPartyLibrary {
    ASSERTJ("org.assertj.core.api.Assertions"),
    GUAVA(ImmutableList.class.getCanonicalName()),
    REACTOR("reactor.core.publisher.Flux");

    private static final String IGNORE_CLASSPATH_COMPAT_FLAG = "ErrorProneSupport:IgnoreClasspathCompat";
    private final Supplier<Boolean> canUse = VisitorState.memoize((Supplier & Serializable)state -> ThirdPartyLibrary.canIntroduceUsage(witnessFqcn, state));

    private ThirdPartyLibrary(String witnessFqcn) {
    }

    public boolean isIntroductionAllowed(VisitorState state) {
        return (Boolean)this.canUse.get(state);
    }

    public static boolean canIntroduceUsage(String typeName, VisitorState state) {
        return ThirdPartyLibrary.shouldIgnoreClasspath(state) || ThirdPartyLibrary.isKnownClass(typeName, state);
    }

    private static boolean isKnownClass(String typeName, VisitorState state) {
        return ThirdPartyLibrary.isPublicClassInSymbolTable(typeName, state) || ThirdPartyLibrary.canLoadPublicClass(typeName, state);
    }

    private static boolean isPublicClassInSymbolTable(String typeName, VisitorState state) {
        Type type = state.getTypeFromString(typeName);
        return type != null && ThirdPartyLibrary.isPublic(type.tsym);
    }

    private static boolean canLoadPublicClass(String typeName, VisitorState state) {
        ClassFinder classFinder = ClassFinder.instance(state.context);
        Symtab symtab = state.getSymtab();
        Symbol.ModuleSymbol module = Source.instance(state.context).compareTo(Source.JDK9) < 0 ? symtab.noModule : symtab.unnamedModule;
        Name binaryName = state.binaryNameFromClassname(typeName);
        try {
            return ThirdPartyLibrary.isPublic(classFinder.loadClass(module, binaryName));
        }
        catch (Symbol.CompletionFailure e) {
            return false;
        }
    }

    private static boolean isPublic(Symbol symbol) {
        return symbol.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private static boolean shouldIgnoreClasspath(VisitorState state) {
        return state.errorProneOptions().getFlags().getBoolean(IGNORE_CLASSPATH_COMPAT_FLAG).orElse(Boolean.FALSE);
    }
}

