/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJObjectRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJObjectRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJObjectRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJObjectRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatIsInstanceOf2Recipe(), new AssertThatIsIsEqualToRecipe(), new AssertThatIsIsNotEqualToRecipe(), new AssertThatHasToStringRecipe(), new AssertThatIsSameAsRecipe(), new AssertThatIsNotSameAsRecipe(), new AssertThatIsNullRecipe(), new AssertThatIsNotNullRecipe(), new AssertThatHasSameHashCodeAsRecipe()});
    }

    @NullMarked
    public static class AssertThatIsInstanceOf2Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJObjectRules.AssertThatIsInstanceOf2`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsInstanceOf2<S, T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(T object, Class<S> clazz) {\n        return assertThat(clazz.isInstance(object)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object, Class<S> clazz) {\n        return assertThat(object).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{clazz:any(java.lang.Class<S>)}.isInstance(#{object:any(T)})).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isInstanceOf(#{clazz:any(java.lang.Class<S>)})").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Class isInstance(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJObjectRules.AssertThatIsIsEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsIsEqualTo<S, T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(S object1, T object2) {\n        return assertThat(object1.equals(object2)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<S> after(S object1, T object2) {\n        return assertThat(object1).isEqualTo(object2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(S)}.equals(#{object2:any(T)})).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(S)}).isEqualTo(#{object2:any(T)})").bindType("org.assertj.core.api.ObjectAssert<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Object equals(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJObjectRules.AssertThatIsIsNotEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsIsNotEqualTo<S, T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(S object1, T object2) {\n        return assertThat(object1.equals(object2)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<S> after(S object1, T object2) {\n        return assertThat(object1).isNotEqualTo(object2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(S)}.equals(#{object2:any(T)})).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(S)}).isNotEqualTo(#{object2:any(T)})").bindType("org.assertj.core.api.ObjectAssert<S>").genericTypes(new String[]{"S", "T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Object equals(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatHasToStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJObjectRules.AssertThatHasToString`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasToString<T> {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(T object, String str) {\n        return assertThat(object.toString()).isEqualTo(str);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object, String str) {\n        return assertThat(object).hasToString(str);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)}.toString()).isEqualTo(#{str:any(java.lang.String)})").bindType("org.assertj.core.api.AbstractStringAssert<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractStringAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).hasToString(#{str:any(java.lang.String)})").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Object toString(..)", true), new UsesMethod("org.assertj.core.api.AbstractStringAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJObjectRules.AssertThatIsSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsSameAs<T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(T object1, T object2) {\n        return Refaster.anyOf(assertThat(object1 == object2).isTrue(), assertThat(object1 != object2).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object1, T object2) {\n        return assertThat(object1).isSameAs(object2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)} == #{object2:any(T)}).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).isSameAs(#{object2:any(T)})").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)} != #{object2:any(T)}).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).isSameAs(#{object2:any(T)})").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsNotSameAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJObjectRules.AssertThatIsNotSameAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotSameAs<T> {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(T object1, T object2) {\n        return Refaster.anyOf(assertThat(object1 == object2).isFalse(), assertThat(object1 != object2).isTrue());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object1, T object2) {\n        return assertThat(object1).isNotSameAs(object2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)} == #{object2:any(T)}).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).isNotSameAs(#{object2:any(T)})").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)} != #{object2:any(T)}).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).isNotSameAs(#{object2:any(T)})").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJObjectRules.AssertThatIsNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNull<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatIsSameAs\")\n    void before(T object) {\n        assertThat(object == null).isTrue();\n    }\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatIsSameAs\")\n    void before2(T object) {\n        assertThat(object != null).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(T object) {\n        assertThat(object).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)} == null).isTrue();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isNull();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)} != null).isFalse();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isNull();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJObjectRules.AssertThatIsNotNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNotNull<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatIsNotSameAs\")\n    AbstractBooleanAssert<? extends AbstractBooleanAssert<?>> before(T object) {\n        return Refaster.anyOf(assertThat(object == null).isFalse(), assertThat(object != null).isTrue());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object) {\n        return assertThat(object).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)} == null).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<? extends org.assertj.core.api.AbstractBooleanAssert<?>>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isNotNull()").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)} != null).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<? extends org.assertj.core.api.AbstractBooleanAssert<?>>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(T)}).isNotNull()").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatHasSameHashCodeAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJObjectRules.AssertThatHasSameHashCodeAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasSameHashCodeAs<T> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(T object1, T object2) {\n        return assertThat(object1.hashCode()).isEqualTo(object2.hashCode());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectAssert<T> after(T object1, T object2) {\n        return assertThat(object1).hasSameHashCodeAs(object2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}.hashCode()).isEqualTo(#{object2:any(T)}.hashCode())").bindType("org.assertj.core.api.AbstractIntegerAssert<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object1:any(T)}).hasSameHashCodeAs(#{object2:any(T)})").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.Object hashCode(..)", true), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

