/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import com.amazonaws.SdkBaseException;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.WebIdentityTokenCredentialsProvider;
import com.amazonaws.retry.PredefinedBackoffStrategies;
import com.amazonaws.retry.v2.AndRetryCondition;
import com.amazonaws.retry.v2.BackoffStrategy;
import com.amazonaws.retry.v2.MaxNumberOfRetriesCondition;
import com.amazonaws.retry.v2.RetryCondition;
import com.amazonaws.retry.v2.RetryOnExceptionsCondition;
import com.amazonaws.retry.v2.RetryPolicy;
import com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.retry.v2.SimpleRetryPolicy;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.msk.auth.iam.internals.EnhancedProfileCredentialsProvider;

public class MSKCredentialProvider
implements AWSCredentialsProvider,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MSKCredentialProvider.class);
    private static final String AWS_PROFILE_NAME_KEY = "awsProfileName";
    private static final String AWS_ROLE_ARN_KEY = "awsRoleArn";
    private static final String AWS_ROLE_EXTERNAL_ID = "awsRoleExternalId";
    private static final String AWS_ROLE_ACCESS_KEY_ID = "awsRoleAccessKeyId";
    private static final String AWS_ROLE_SECRET_ACCESS_KEY = "awsRoleSecretAccessKey";
    private static final String AWS_ROLE_SESSION_KEY = "awsRoleSessionName";
    private static final String AWS_ROLE_SESSION_TOKEN = "awsRoleSessionToken";
    private static final String AWS_STS_REGION = "awsStsRegion";
    private static final String AWS_DEBUG_CREDS_KEY = "awsDebugCreds";
    private static final String AWS_MAX_RETRIES = "awsMaxRetries";
    private static final String AWS_MAX_BACK_OFF_TIME_MS = "awsMaxBackOffTimeMs";
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_MAX_BACK_OFF_TIME_MS = 5000;
    private static final int BASE_DELAY = 500;
    private final List<AutoCloseable> closeableProviders;
    private final AWSCredentialsProvider compositeDelegate;
    private final Boolean shouldDebugCreds;
    private final String stsRegion;
    private final RetryPolicy retryPolicy;

    public MSKCredentialProvider(Map<String, ?> options) {
        this(new ProviderBuilder(options));
    }

    MSKCredentialProvider(ProviderBuilder builder) {
        this(builder.getProviders(), builder.shouldDebugCreds(), builder.getStsRegion(), builder.getMaxRetries(), builder.getMaxBackOffTimeMs());
    }

    MSKCredentialProvider(List<AWSCredentialsProvider> providers, Boolean shouldDebugCreds, String stsRegion, int maxRetries, int maxBackOffTimeMs) {
        ArrayList<AWSCredentialsProvider> delegateList = new ArrayList<AWSCredentialsProvider>(providers);
        delegateList.add((AWSCredentialsProvider)this.getDefaultProvider());
        this.compositeDelegate = new AWSCredentialsProviderChain(delegateList);
        this.closeableProviders = providers.stream().filter(p -> p instanceof AutoCloseable).map(p -> (AutoCloseable)p).collect(Collectors.toList());
        this.shouldDebugCreds = shouldDebugCreds;
        this.stsRegion = stsRegion;
        this.retryPolicy = maxRetries > 0 ? new SimpleRetryPolicy((RetryCondition)new AndRetryCondition(new RetryCondition[]{new RetryOnExceptionsCondition(Collections.singletonList(SdkClientException.class)), new MaxNumberOfRetriesCondition(maxRetries)}), (BackoffStrategy)new PredefinedBackoffStrategies.FullJitterBackoffStrategy(500, maxBackOffTimeMs)) : new SimpleRetryPolicy(c -> false, (BackoffStrategy)new PredefinedBackoffStrategies.FullJitterBackoffStrategy(500, maxBackOffTimeMs));
    }

    protected AWSCredentialsProviderChain getDefaultProvider() {
        return new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), WebIdentityTokenCredentialsProvider.create(), new EnhancedProfileCredentialsProvider(), new EC2ContainerCredentialsProviderWrapper()});
    }

    public AWSCredentials getCredentials() {
        AWSCredentials credentials = this.loadCredentialsWithRetry();
        if (credentials != null && this.shouldDebugCreds.booleanValue() && log.isDebugEnabled()) {
            this.logCallerIdentity(credentials);
        }
        return credentials;
    }

    private AWSCredentials loadCredentialsWithRetry() {
        RetryPolicyContext retryPolicyContext = RetryPolicyContext.builder().build();
        boolean shouldTry = true;
        try {
            while (shouldTry) {
                try {
                    AWSCredentials credentials = this.compositeDelegate.getCredentials();
                    if (credentials == null) {
                        throw new SdkClientException("Composite delegate returned empty credentials.");
                    }
                    return credentials;
                }
                catch (SdkBaseException se) {
                    log.warn("Exception loading credentials. Retry Attempts: {}", (Object)retryPolicyContext.retriesAttempted(), (Object)se);
                    retryPolicyContext = this.createRetryPolicyContext(se, retryPolicyContext.retriesAttempted());
                    shouldTry = this.retryPolicy.shouldRetry(retryPolicyContext);
                    if (shouldTry) {
                        Thread.sleep(this.retryPolicy.computeDelayBeforeNextRetry(retryPolicyContext));
                        retryPolicyContext = this.createRetryPolicyContext(retryPolicyContext.exception(), retryPolicyContext.retriesAttempted() + 1);
                        continue;
                    }
                    throw se;
                }
            }
            throw new SdkClientException("loadCredentialsWithRetry in unexpected location " + retryPolicyContext.totalRequests(), (Throwable)retryPolicyContext.exception());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for credentials.", ie);
        }
    }

    private RetryPolicyContext createRetryPolicyContext(SdkBaseException sdkException, int retriesAttempted) {
        return RetryPolicyContext.builder().exception(sdkException).retriesAttempted(retriesAttempted).build();
    }

    private void logCallerIdentity(AWSCredentials credentials) {
        try {
            AWSSecurityTokenService stsClient = this.getStsClientForDebuggingCreds(credentials);
            GetCallerIdentityResult response = stsClient.getCallerIdentity(new GetCallerIdentityRequest());
            log.debug("The identity of the credentials is {}", (Object)response.toString());
        }
        catch (Exception e) {
            log.warn("Error identifying caller identity. If this is not transient, does this application haveaccess to AWS STS?", (Throwable)e);
        }
    }

    AWSSecurityTokenService getStsClientForDebuggingCreds(final AWSCredentials credentials) {
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(this.stsRegion)).withCredentials(new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return credentials;
            }

            public void refresh() {
            }
        })).build();
    }

    public void refresh() {
        this.compositeDelegate.refresh();
    }

    @Override
    public void close() {
        this.closeableProviders.stream().forEach(p -> {
            try {
                p.close();
            }
            catch (Exception e) {
                log.warn("Error closing credential provider", (Throwable)e);
            }
        });
    }

    Boolean getShouldDebugCreds() {
        return this.shouldDebugCreds;
    }

    public static class ProviderBuilder {
        private final Map<String, ?> optionsMap;

        public ProviderBuilder(Map<String, ?> optionsMap) {
            this.optionsMap = optionsMap;
            if (log.isDebugEnabled()) {
                log.debug("Number of options to configure credential provider {}", (Object)optionsMap.size());
            }
        }

        public List<AWSCredentialsProvider> getProviders() {
            ArrayList<AWSCredentialsProvider> providers = new ArrayList<AWSCredentialsProvider>();
            this.getProfileProvider().ifPresent(providers::add);
            this.getStsRoleProvider().ifPresent(providers::add);
            return providers;
        }

        public Boolean shouldDebugCreds() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_DEBUG_CREDS_KEY)).map(d -> d.equals("true")).orElse(false);
        }

        public String getStsRegion() {
            return Optional.ofNullable((String)this.optionsMap.get(MSKCredentialProvider.AWS_STS_REGION)).orElse("aws-global");
        }

        public int getMaxRetries() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_MAX_RETRIES)).map(p -> (String)p).map(Integer::parseInt).orElse(3);
        }

        public int getMaxBackOffTimeMs() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_MAX_BACK_OFF_TIME_MS)).map(p -> (String)p).map(Integer::parseInt).orElse(5000);
        }

        private Optional<EnhancedProfileCredentialsProvider> getProfileProvider() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_PROFILE_NAME_KEY)).map(p -> {
                if (log.isDebugEnabled()) {
                    log.debug("Profile name {}", p);
                }
                return this.createEnhancedProfileCredentialsProvider((String)p);
            });
        }

        EnhancedProfileCredentialsProvider createEnhancedProfileCredentialsProvider(String p) {
            return new EnhancedProfileCredentialsProvider(p);
        }

        private Optional<STSAssumeRoleSessionCredentialsProvider> getStsRoleProvider() {
            return Optional.ofNullable(this.optionsMap.get(MSKCredentialProvider.AWS_ROLE_ARN_KEY)).map(p -> {
                if (log.isDebugEnabled()) {
                    log.debug("Role ARN {}", p);
                }
                String sessionName = Optional.ofNullable((String)this.optionsMap.get(MSKCredentialProvider.AWS_ROLE_SESSION_KEY)).orElse("aws-msk-iam-auth");
                String stsRegion = this.getStsRegion();
                String accessKey = this.optionsMap.getOrDefault(MSKCredentialProvider.AWS_ROLE_ACCESS_KEY_ID, null);
                String secretKey = this.optionsMap.getOrDefault(MSKCredentialProvider.AWS_ROLE_SECRET_ACCESS_KEY, null);
                String sessionToken = this.optionsMap.getOrDefault(MSKCredentialProvider.AWS_ROLE_SESSION_TOKEN, null);
                String externalId = this.optionsMap.getOrDefault(MSKCredentialProvider.AWS_ROLE_EXTERNAL_ID, null);
                if (accessKey != null && secretKey != null) {
                    AWSStaticCredentialsProvider credentials = new AWSStaticCredentialsProvider((AWSCredentials)(sessionToken != null ? new BasicSessionCredentials(accessKey, secretKey, sessionToken) : new BasicAWSCredentials(accessKey, secretKey)));
                    return this.createSTSRoleCredentialProvider((String)p, sessionName, stsRegion, (AWSCredentialsProvider)credentials);
                }
                if (externalId != null) {
                    return this.createSTSRoleCredentialProvider((String)p, externalId, sessionName, stsRegion);
                }
                return this.createSTSRoleCredentialProvider((String)p, sessionName, stsRegion);
            });
        }

        STSAssumeRoleSessionCredentialsProvider createSTSRoleCredentialProvider(String roleArn, String sessionName, String stsRegion) {
            AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(stsRegion)).build();
            return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, sessionName).withStsClient(stsClient).build();
        }

        STSAssumeRoleSessionCredentialsProvider createSTSRoleCredentialProvider(String roleArn, String sessionName, String stsRegion, AWSCredentialsProvider credentials) {
            AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(stsRegion)).withCredentials(credentials)).build();
            return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, sessionName).withStsClient(stsClient).build();
        }

        STSAssumeRoleSessionCredentialsProvider createSTSRoleCredentialProvider(String roleArn, String externalId, String sessionName, String stsRegion) {
            AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(stsRegion)).build();
            return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, sessionName).withStsClient(stsClient).withExternalId(externalId).build();
        }
    }
}

