/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.msk.auth.iam.internals;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.profiles.ProfileFile;

public class EnhancedProfileCredentialsProvider
implements AWSCredentialsProvider {
    private final ProfileCredentialsProvider delegate;

    public EnhancedProfileCredentialsProvider() {
        this.delegate = ProfileCredentialsProvider.create();
    }

    public EnhancedProfileCredentialsProvider(String profileName) {
        this.delegate = ProfileCredentialsProvider.create((String)profileName);
    }

    public EnhancedProfileCredentialsProvider(ProfileFile profileFile, String profileName) {
        this.delegate = ProfileCredentialsProvider.builder().profileFile(profileFile).profileName(profileName).build();
    }

    public AWSCredentials getCredentials() {
        AwsCredentials credentialsV2 = this.delegate.resolveCredentials();
        if (credentialsV2 instanceof AwsSessionCredentials) {
            AwsSessionCredentials sessionCredentialsV2 = (AwsSessionCredentials)credentialsV2;
            return new BasicSessionCredentials(sessionCredentialsV2.accessKeyId(), sessionCredentialsV2.secretAccessKey(), sessionCredentialsV2.sessionToken());
        }
        return new BasicAWSCredentials(credentialsV2.accessKeyId(), credentialsV2.secretAccessKey());
    }

    public void refresh() {
    }
}

