/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
 * </p>
 * <p>
 * Event destinations, such as Amazon Kinesis Firehose, are associated with configuration sets, which enable you to
 * publish email sending events. For information about using configuration sets, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisFirehoseDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisFirehoseDestination.Builder, KinesisFirehoseDestination> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IAMRoleARN").getter(getter(KinesisFirehoseDestination::iamRoleARN)).setter(setter(Builder::iamRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleARN").build()).build();

    private static final SdkField<String> DELIVERY_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStreamARN").getter(getter(KinesisFirehoseDestination::deliveryStreamARN))
            .setter(setter(Builder::deliveryStreamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD,
            DELIVERY_STREAM_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String iamRoleARN;

    private final String deliveryStreamARN;

    private KinesisFirehoseDestination(BuilderImpl builder) {
        this.iamRoleARN = builder.iamRoleARN;
        this.deliveryStreamARN = builder.deliveryStreamARN;
    }

    /**
     * <p>
     * The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose
     * stream.
     * </p>
     * 
     * @return The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis
     *         Firehose stream.
     */
    public final String iamRoleARN() {
        return iamRoleARN;
    }

    /**
     * <p>
     * The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
     * </p>
     * 
     * @return The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
     */
    public final String deliveryStreamARN() {
        return deliveryStreamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseDestination)) {
            return false;
        }
        KinesisFirehoseDestination other = (KinesisFirehoseDestination) obj;
        return Objects.equals(iamRoleARN(), other.iamRoleARN()) && Objects.equals(deliveryStreamARN(), other.deliveryStreamARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisFirehoseDestination").add("IAMRoleARN", iamRoleARN())
                .add("DeliveryStreamARN", deliveryStreamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IAMRoleARN":
            return Optional.ofNullable(clazz.cast(iamRoleARN()));
        case "DeliveryStreamARN":
            return Optional.ofNullable(clazz.cast(deliveryStreamARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IAMRoleARN", IAM_ROLE_ARN_FIELD);
        map.put("DeliveryStreamARN", DELIVERY_STREAM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisFirehoseDestination, T> g) {
        return obj -> g.apply((KinesisFirehoseDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisFirehoseDestination> {
        /**
         * <p>
         * The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose
         * stream.
         * </p>
         * 
         * @param iamRoleARN
         *        The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis
         *        Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleARN(String iamRoleARN);

        /**
         * <p>
         * The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
         * </p>
         * 
         * @param deliveryStreamARN
         *        The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamARN(String deliveryStreamARN);
    }

    static final class BuilderImpl implements Builder {
        private String iamRoleARN;

        private String deliveryStreamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseDestination model) {
            iamRoleARN(model.iamRoleARN);
            deliveryStreamARN(model.deliveryStreamARN);
        }

        public final String getIamRoleARN() {
            return iamRoleARN;
        }

        public final void setIamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
        }

        @Override
        public final Builder iamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
            return this;
        }

        public final String getDeliveryStreamARN() {
            return deliveryStreamARN;
        }

        public final void setDeliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
        }

        @Override
        public final Builder deliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
            return this;
        }

        @Override
        public KinesisFirehoseDestination build() {
            return new KinesisFirehoseDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
