/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MasterUserSecret
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MasterUserSecret> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(MasterUserSecret.getter(MasterUserSecret::secretArn)).setter(MasterUserSecret.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> SECRET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretStatus").getter(MasterUserSecret.getter(MasterUserSecret::secretStatus)).setter(MasterUserSecret.setter(Builder::secretStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretStatus").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(MasterUserSecret.getter(MasterUserSecret::kmsKeyId)).setter(MasterUserSecret.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD, SECRET_STATUS_FIELD, KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MasterUserSecret.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String secretArn;
    private final String secretStatus;
    private final String kmsKeyId;

    private MasterUserSecret(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.secretStatus = builder.secretStatus;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String secretStatus() {
        return this.secretStatus;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MasterUserSecret)) {
            return false;
        }
        MasterUserSecret other = (MasterUserSecret)obj;
        return Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.secretStatus(), other.secretStatus()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"MasterUserSecret").add("SecretArn", (Object)this.secretArn()).add("SecretStatus", (Object)this.secretStatus()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "SecretStatus": {
                return Optional.ofNullable(clazz.cast(this.secretStatus()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("SecretStatus", SECRET_STATUS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MasterUserSecret, T> g) {
        return obj -> g.apply((MasterUserSecret)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String secretArn;
        private String secretStatus;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MasterUserSecret model) {
            this.secretArn(model.secretArn);
            this.secretStatus(model.secretStatus);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSecretStatus() {
            return this.secretStatus;
        }

        public final void setSecretStatus(String secretStatus) {
            this.secretStatus = secretStatus;
        }

        @Override
        public final Builder secretStatus(String secretStatus) {
            this.secretStatus = secretStatus;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public MasterUserSecret build() {
            return new MasterUserSecret(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MasterUserSecret> {
        public Builder secretArn(String var1);

        public Builder secretStatus(String var1);

        public Builder kmsKeyId(String var1);
    }
}

