/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Available option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptionGroupOption implements SdkPojo, Serializable,
        ToCopyableBuilder<OptionGroupOption.Builder, OptionGroupOption> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OptionGroupOption::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(OptionGroupOption::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineName").getter(getter(OptionGroupOption::engineName)).setter(setter(Builder::engineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()).build();

    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorEngineVersion").getter(getter(OptionGroupOption::majorEngineVersion))
            .setter(setter(Builder::majorEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build())
            .build();

    private static final SdkField<String> MINIMUM_REQUIRED_MINOR_ENGINE_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MinimumRequiredMinorEngineVersion")
            .getter(getter(OptionGroupOption::minimumRequiredMinorEngineVersion))
            .setter(setter(Builder::minimumRequiredMinorEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumRequiredMinorEngineVersion")
                    .build()).build();

    private static final SdkField<Boolean> PORT_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PortRequired").getter(getter(OptionGroupOption::portRequired)).setter(setter(Builder::portRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRequired").build()).build();

    private static final SdkField<Integer> DEFAULT_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultPort").getter(getter(OptionGroupOption::defaultPort)).setter(setter(Builder::defaultPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPort").build()).build();

    private static final SdkField<List<String>> OPTIONS_DEPENDED_ON_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OptionsDependedOn")
            .getter(getter(OptionGroupOption::optionsDependedOn))
            .setter(setter(Builder::optionsDependedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsDependedOn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionName").build()).build()).build()).build();

    private static final SdkField<List<String>> OPTIONS_CONFLICTS_WITH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OptionsConflictsWith")
            .getter(getter(OptionGroupOption::optionsConflictsWith))
            .setter(setter(Builder::optionsConflictsWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsConflictsWith").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionConflictName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionConflictName").build()).build()).build()).build();

    private static final SdkField<Boolean> PERSISTENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Persistent").getter(getter(OptionGroupOption::persistent)).setter(setter(Builder::persistent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persistent").build()).build();

    private static final SdkField<Boolean> PERMANENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Permanent").getter(getter(OptionGroupOption::permanent)).setter(setter(Builder::permanent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permanent").build()).build();

    private static final SdkField<Boolean> REQUIRES_AUTO_MINOR_ENGINE_VERSION_UPGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequiresAutoMinorEngineVersionUpgrade")
            .getter(getter(OptionGroupOption::requiresAutoMinorEngineVersionUpgrade))
            .setter(setter(Builder::requiresAutoMinorEngineVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RequiresAutoMinorEngineVersionUpgrade").build()).build();

    private static final SdkField<Boolean> VPC_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VpcOnly").getter(getter(OptionGroupOption::vpcOnly)).setter(setter(Builder::vpcOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOnly").build()).build();

    private static final SdkField<Boolean> SUPPORTS_OPTION_VERSION_DOWNGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsOptionVersionDowngrade")
            .getter(getter(OptionGroupOption::supportsOptionVersionDowngrade))
            .setter(setter(Builder::supportsOptionVersionDowngrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsOptionVersionDowngrade")
                    .build()).build();

    private static final SdkField<List<OptionGroupOptionSetting>> OPTION_GROUP_OPTION_SETTINGS_FIELD = SdkField
            .<List<OptionGroupOptionSetting>> builder(MarshallingType.LIST)
            .memberName("OptionGroupOptionSettings")
            .getter(getter(OptionGroupOption::optionGroupOptionSettings))
            .setter(setter(Builder::optionGroupOptionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupOptionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionGroupOptionSetting")
                            .memberFieldInfo(
                                    SdkField.<OptionGroupOptionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionGroupOptionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionGroupOptionSetting").build()).build()).build()).build();

    private static final SdkField<List<OptionVersion>> OPTION_GROUP_OPTION_VERSIONS_FIELD = SdkField
            .<List<OptionVersion>> builder(MarshallingType.LIST)
            .memberName("OptionGroupOptionVersions")
            .getter(getter(OptionGroupOption::optionGroupOptionVersions))
            .setter(setter(Builder::optionGroupOptionVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupOptionVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionVersion")
                            .memberFieldInfo(
                                    SdkField.<OptionVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionVersion").build()).build()).build()).build();

    private static final SdkField<Boolean> COPYABLE_CROSS_ACCOUNT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyableCrossAccount").getter(getter(OptionGroupOption::copyableCrossAccount))
            .setter(setter(Builder::copyableCrossAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyableCrossAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ENGINE_NAME_FIELD, MAJOR_ENGINE_VERSION_FIELD, MINIMUM_REQUIRED_MINOR_ENGINE_VERSION_FIELD, PORT_REQUIRED_FIELD,
            DEFAULT_PORT_FIELD, OPTIONS_DEPENDED_ON_FIELD, OPTIONS_CONFLICTS_WITH_FIELD, PERSISTENT_FIELD, PERMANENT_FIELD,
            REQUIRES_AUTO_MINOR_ENGINE_VERSION_UPGRADE_FIELD, VPC_ONLY_FIELD, SUPPORTS_OPTION_VERSION_DOWNGRADE_FIELD,
            OPTION_GROUP_OPTION_SETTINGS_FIELD, OPTION_GROUP_OPTION_VERSIONS_FIELD, COPYABLE_CROSS_ACCOUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String engineName;

    private final String majorEngineVersion;

    private final String minimumRequiredMinorEngineVersion;

    private final Boolean portRequired;

    private final Integer defaultPort;

    private final List<String> optionsDependedOn;

    private final List<String> optionsConflictsWith;

    private final Boolean persistent;

    private final Boolean permanent;

    private final Boolean requiresAutoMinorEngineVersionUpgrade;

    private final Boolean vpcOnly;

    private final Boolean supportsOptionVersionDowngrade;

    private final List<OptionGroupOptionSetting> optionGroupOptionSettings;

    private final List<OptionVersion> optionGroupOptionVersions;

    private final Boolean copyableCrossAccount;

    private OptionGroupOption(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.minimumRequiredMinorEngineVersion = builder.minimumRequiredMinorEngineVersion;
        this.portRequired = builder.portRequired;
        this.defaultPort = builder.defaultPort;
        this.optionsDependedOn = builder.optionsDependedOn;
        this.optionsConflictsWith = builder.optionsConflictsWith;
        this.persistent = builder.persistent;
        this.permanent = builder.permanent;
        this.requiresAutoMinorEngineVersionUpgrade = builder.requiresAutoMinorEngineVersionUpgrade;
        this.vpcOnly = builder.vpcOnly;
        this.supportsOptionVersionDowngrade = builder.supportsOptionVersionDowngrade;
        this.optionGroupOptionSettings = builder.optionGroupOptionSettings;
        this.optionGroupOptionVersions = builder.optionGroupOptionVersions;
        this.copyableCrossAccount = builder.copyableCrossAccount;
    }

    /**
     * <p>
     * The name of the option.
     * </p>
     * 
     * @return The name of the option.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the option.
     * </p>
     * 
     * @return The description of the option.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the engine that this option can be applied to.
     * </p>
     * 
     * @return The name of the engine that this option can be applied to.
     */
    public final String engineName() {
        return engineName;
    }

    /**
     * <p>
     * Indicates the major engine version that the option is available for.
     * </p>
     * 
     * @return Indicates the major engine version that the option is available for.
     */
    public final String majorEngineVersion() {
        return majorEngineVersion;
    }

    /**
     * <p>
     * The minimum required engine version for the option to be applied.
     * </p>
     * 
     * @return The minimum required engine version for the option to be applied.
     */
    public final String minimumRequiredMinorEngineVersion() {
        return minimumRequiredMinorEngineVersion;
    }

    /**
     * <p>
     * Indicates whether the option requires a port.
     * </p>
     * 
     * @return Indicates whether the option requires a port.
     */
    public final Boolean portRequired() {
        return portRequired;
    }

    /**
     * <p>
     * If the option requires a port, specifies the default port for the option.
     * </p>
     * 
     * @return If the option requires a port, specifies the default port for the option.
     */
    public final Integer defaultPort() {
        return defaultPort;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionsDependedOn property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionsDependedOn() {
        return optionsDependedOn != null && !(optionsDependedOn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The options that are prerequisites for this option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionsDependedOn} method.
     * </p>
     * 
     * @return The options that are prerequisites for this option.
     */
    public final List<String> optionsDependedOn() {
        return optionsDependedOn;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionsConflictsWith property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionsConflictsWith() {
        return optionsConflictsWith != null && !(optionsConflictsWith instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The options that conflict with this option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionsConflictsWith} method.
     * </p>
     * 
     * @return The options that conflict with this option.
     */
    public final List<String> optionsConflictsWith() {
        return optionsConflictsWith;
    }

    /**
     * <p>
     * Persistent options can't be removed from an option group while DB instances are associated with the option group.
     * If you disassociate all DB instances from the option group, your can remove the persistent option from the option
     * group.
     * </p>
     * 
     * @return Persistent options can't be removed from an option group while DB instances are associated with the
     *         option group. If you disassociate all DB instances from the option group, your can remove the persistent
     *         option from the option group.
     */
    public final Boolean persistent() {
        return persistent;
    }

    /**
     * <p>
     * Permanent options can never be removed from an option group. An option group containing a permanent option can't
     * be removed from a DB instance.
     * </p>
     * 
     * @return Permanent options can never be removed from an option group. An option group containing a permanent
     *         option can't be removed from a DB instance.
     */
    public final Boolean permanent() {
        return permanent;
    }

    /**
     * <p>
     * If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use this
     * option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by modifying your DB
     * instance later.
     * </p>
     * 
     * @return If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use
     *         this option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by
     *         modifying your DB instance later.
     */
    public final Boolean requiresAutoMinorEngineVersionUpgrade() {
        return requiresAutoMinorEngineVersionUpgrade;
    }

    /**
     * <p>
     * If true, you can only use this option with a DB instance that is in a VPC.
     * </p>
     * 
     * @return If true, you can only use this option with a DB instance that is in a VPC.
     */
    public final Boolean vpcOnly() {
        return vpcOnly;
    }

    /**
     * <p>
     * If true, you can change the option to an earlier version of the option. This only applies to options that have
     * different versions available.
     * </p>
     * 
     * @return If true, you can change the option to an earlier version of the option. This only applies to options that
     *         have different versions available.
     */
    public final Boolean supportsOptionVersionDowngrade() {
        return supportsOptionVersionDowngrade;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionGroupOptionSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOptionGroupOptionSettings() {
        return optionGroupOptionSettings != null && !(optionGroupOptionSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The option settings that are available (and the default value) for each option in an option group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionGroupOptionSettings} method.
     * </p>
     * 
     * @return The option settings that are available (and the default value) for each option in an option group.
     */
    public final List<OptionGroupOptionSetting> optionGroupOptionSettings() {
        return optionGroupOptionSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionGroupOptionVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOptionGroupOptionVersions() {
        return optionGroupOptionVersions != null && !(optionGroupOptionVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The versions that are available for the option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionGroupOptionVersions} method.
     * </p>
     * 
     * @return The versions that are available for the option.
     */
    public final List<OptionVersion> optionGroupOptionVersions() {
        return optionGroupOptionVersions;
    }

    /**
     * <p>
     * Indicates whether the option can be copied across Amazon Web Services accounts.
     * </p>
     * 
     * @return Indicates whether the option can be copied across Amazon Web Services accounts.
     */
    public final Boolean copyableCrossAccount() {
        return copyableCrossAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineName());
        hashCode = 31 * hashCode + Objects.hashCode(majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(minimumRequiredMinorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(portRequired());
        hashCode = 31 * hashCode + Objects.hashCode(defaultPort());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionsDependedOn() ? optionsDependedOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionsConflictsWith() ? optionsConflictsWith() : null);
        hashCode = 31 * hashCode + Objects.hashCode(persistent());
        hashCode = 31 * hashCode + Objects.hashCode(permanent());
        hashCode = 31 * hashCode + Objects.hashCode(requiresAutoMinorEngineVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOnly());
        hashCode = 31 * hashCode + Objects.hashCode(supportsOptionVersionDowngrade());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionGroupOptionSettings() ? optionGroupOptionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionGroupOptionVersions() ? optionGroupOptionVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(copyableCrossAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroupOption)) {
            return false;
        }
        OptionGroupOption other = (OptionGroupOption) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(engineName(), other.engineName())
                && Objects.equals(majorEngineVersion(), other.majorEngineVersion())
                && Objects.equals(minimumRequiredMinorEngineVersion(), other.minimumRequiredMinorEngineVersion())
                && Objects.equals(portRequired(), other.portRequired()) && Objects.equals(defaultPort(), other.defaultPort())
                && hasOptionsDependedOn() == other.hasOptionsDependedOn()
                && Objects.equals(optionsDependedOn(), other.optionsDependedOn())
                && hasOptionsConflictsWith() == other.hasOptionsConflictsWith()
                && Objects.equals(optionsConflictsWith(), other.optionsConflictsWith())
                && Objects.equals(persistent(), other.persistent()) && Objects.equals(permanent(), other.permanent())
                && Objects.equals(requiresAutoMinorEngineVersionUpgrade(), other.requiresAutoMinorEngineVersionUpgrade())
                && Objects.equals(vpcOnly(), other.vpcOnly())
                && Objects.equals(supportsOptionVersionDowngrade(), other.supportsOptionVersionDowngrade())
                && hasOptionGroupOptionSettings() == other.hasOptionGroupOptionSettings()
                && Objects.equals(optionGroupOptionSettings(), other.optionGroupOptionSettings())
                && hasOptionGroupOptionVersions() == other.hasOptionGroupOptionVersions()
                && Objects.equals(optionGroupOptionVersions(), other.optionGroupOptionVersions())
                && Objects.equals(copyableCrossAccount(), other.copyableCrossAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptionGroupOption").add("Name", name()).add("Description", description())
                .add("EngineName", engineName()).add("MajorEngineVersion", majorEngineVersion())
                .add("MinimumRequiredMinorEngineVersion", minimumRequiredMinorEngineVersion())
                .add("PortRequired", portRequired()).add("DefaultPort", defaultPort())
                .add("OptionsDependedOn", hasOptionsDependedOn() ? optionsDependedOn() : null)
                .add("OptionsConflictsWith", hasOptionsConflictsWith() ? optionsConflictsWith() : null)
                .add("Persistent", persistent()).add("Permanent", permanent())
                .add("RequiresAutoMinorEngineVersionUpgrade", requiresAutoMinorEngineVersionUpgrade()).add("VpcOnly", vpcOnly())
                .add("SupportsOptionVersionDowngrade", supportsOptionVersionDowngrade())
                .add("OptionGroupOptionSettings", hasOptionGroupOptionSettings() ? optionGroupOptionSettings() : null)
                .add("OptionGroupOptionVersions", hasOptionGroupOptionVersions() ? optionGroupOptionVersions() : null)
                .add("CopyableCrossAccount", copyableCrossAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EngineName":
            return Optional.ofNullable(clazz.cast(engineName()));
        case "MajorEngineVersion":
            return Optional.ofNullable(clazz.cast(majorEngineVersion()));
        case "MinimumRequiredMinorEngineVersion":
            return Optional.ofNullable(clazz.cast(minimumRequiredMinorEngineVersion()));
        case "PortRequired":
            return Optional.ofNullable(clazz.cast(portRequired()));
        case "DefaultPort":
            return Optional.ofNullable(clazz.cast(defaultPort()));
        case "OptionsDependedOn":
            return Optional.ofNullable(clazz.cast(optionsDependedOn()));
        case "OptionsConflictsWith":
            return Optional.ofNullable(clazz.cast(optionsConflictsWith()));
        case "Persistent":
            return Optional.ofNullable(clazz.cast(persistent()));
        case "Permanent":
            return Optional.ofNullable(clazz.cast(permanent()));
        case "RequiresAutoMinorEngineVersionUpgrade":
            return Optional.ofNullable(clazz.cast(requiresAutoMinorEngineVersionUpgrade()));
        case "VpcOnly":
            return Optional.ofNullable(clazz.cast(vpcOnly()));
        case "SupportsOptionVersionDowngrade":
            return Optional.ofNullable(clazz.cast(supportsOptionVersionDowngrade()));
        case "OptionGroupOptionSettings":
            return Optional.ofNullable(clazz.cast(optionGroupOptionSettings()));
        case "OptionGroupOptionVersions":
            return Optional.ofNullable(clazz.cast(optionGroupOptionVersions()));
        case "CopyableCrossAccount":
            return Optional.ofNullable(clazz.cast(copyableCrossAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionGroupOption, T> g) {
        return obj -> g.apply((OptionGroupOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptionGroupOption> {
        /**
         * <p>
         * The name of the option.
         * </p>
         * 
         * @param name
         *        The name of the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the option.
         * </p>
         * 
         * @param description
         *        The description of the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the engine that this option can be applied to.
         * </p>
         * 
         * @param engineName
         *        The name of the engine that this option can be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineName(String engineName);

        /**
         * <p>
         * Indicates the major engine version that the option is available for.
         * </p>
         * 
         * @param majorEngineVersion
         *        Indicates the major engine version that the option is available for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorEngineVersion(String majorEngineVersion);

        /**
         * <p>
         * The minimum required engine version for the option to be applied.
         * </p>
         * 
         * @param minimumRequiredMinorEngineVersion
         *        The minimum required engine version for the option to be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumRequiredMinorEngineVersion(String minimumRequiredMinorEngineVersion);

        /**
         * <p>
         * Indicates whether the option requires a port.
         * </p>
         * 
         * @param portRequired
         *        Indicates whether the option requires a port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRequired(Boolean portRequired);

        /**
         * <p>
         * If the option requires a port, specifies the default port for the option.
         * </p>
         * 
         * @param defaultPort
         *        If the option requires a port, specifies the default port for the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPort(Integer defaultPort);

        /**
         * <p>
         * The options that are prerequisites for this option.
         * </p>
         * 
         * @param optionsDependedOn
         *        The options that are prerequisites for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsDependedOn(Collection<String> optionsDependedOn);

        /**
         * <p>
         * The options that are prerequisites for this option.
         * </p>
         * 
         * @param optionsDependedOn
         *        The options that are prerequisites for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsDependedOn(String... optionsDependedOn);

        /**
         * <p>
         * The options that conflict with this option.
         * </p>
         * 
         * @param optionsConflictsWith
         *        The options that conflict with this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsConflictsWith(Collection<String> optionsConflictsWith);

        /**
         * <p>
         * The options that conflict with this option.
         * </p>
         * 
         * @param optionsConflictsWith
         *        The options that conflict with this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsConflictsWith(String... optionsConflictsWith);

        /**
         * <p>
         * Persistent options can't be removed from an option group while DB instances are associated with the option
         * group. If you disassociate all DB instances from the option group, your can remove the persistent option from
         * the option group.
         * </p>
         * 
         * @param persistent
         *        Persistent options can't be removed from an option group while DB instances are associated with the
         *        option group. If you disassociate all DB instances from the option group, your can remove the
         *        persistent option from the option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistent(Boolean persistent);

        /**
         * <p>
         * Permanent options can never be removed from an option group. An option group containing a permanent option
         * can't be removed from a DB instance.
         * </p>
         * 
         * @param permanent
         *        Permanent options can never be removed from an option group. An option group containing a permanent
         *        option can't be removed from a DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permanent(Boolean permanent);

        /**
         * <p>
         * If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use this
         * option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by modifying
         * your DB instance later.
         * </p>
         * 
         * @param requiresAutoMinorEngineVersionUpgrade
         *        If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can
         *        use this option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or
         *        by modifying your DB instance later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresAutoMinorEngineVersionUpgrade(Boolean requiresAutoMinorEngineVersionUpgrade);

        /**
         * <p>
         * If true, you can only use this option with a DB instance that is in a VPC.
         * </p>
         * 
         * @param vpcOnly
         *        If true, you can only use this option with a DB instance that is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOnly(Boolean vpcOnly);

        /**
         * <p>
         * If true, you can change the option to an earlier version of the option. This only applies to options that
         * have different versions available.
         * </p>
         * 
         * @param supportsOptionVersionDowngrade
         *        If true, you can change the option to an earlier version of the option. This only applies to options
         *        that have different versions available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsOptionVersionDowngrade(Boolean supportsOptionVersionDowngrade);

        /**
         * <p>
         * The option settings that are available (and the default value) for each option in an option group.
         * </p>
         * 
         * @param optionGroupOptionSettings
         *        The option settings that are available (and the default value) for each option in an option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupOptionSettings(Collection<OptionGroupOptionSetting> optionGroupOptionSettings);

        /**
         * <p>
         * The option settings that are available (and the default value) for each option in an option group.
         * </p>
         * 
         * @param optionGroupOptionSettings
         *        The option settings that are available (and the default value) for each option in an option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupOptionSettings(OptionGroupOptionSetting... optionGroupOptionSettings);

        /**
         * <p>
         * The option settings that are available (and the default value) for each option in an option group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #optionGroupOptionSettings(List<OptionGroupOptionSetting>)}.
         * 
         * @param optionGroupOptionSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionGroupOptionSettings(java.util.Collection<OptionGroupOptionSetting>)
         */
        Builder optionGroupOptionSettings(Consumer<OptionGroupOptionSetting.Builder>... optionGroupOptionSettings);

        /**
         * <p>
         * The versions that are available for the option.
         * </p>
         * 
         * @param optionGroupOptionVersions
         *        The versions that are available for the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupOptionVersions(Collection<OptionVersion> optionGroupOptionVersions);

        /**
         * <p>
         * The versions that are available for the option.
         * </p>
         * 
         * @param optionGroupOptionVersions
         *        The versions that are available for the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupOptionVersions(OptionVersion... optionGroupOptionVersions);

        /**
         * <p>
         * The versions that are available for the option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.OptionVersion.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.OptionVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.OptionVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #optionGroupOptionVersions(List<OptionVersion>)}.
         * 
         * @param optionGroupOptionVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.OptionVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionGroupOptionVersions(java.util.Collection<OptionVersion>)
         */
        Builder optionGroupOptionVersions(Consumer<OptionVersion.Builder>... optionGroupOptionVersions);

        /**
         * <p>
         * Indicates whether the option can be copied across Amazon Web Services accounts.
         * </p>
         * 
         * @param copyableCrossAccount
         *        Indicates whether the option can be copied across Amazon Web Services accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyableCrossAccount(Boolean copyableCrossAccount);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String engineName;

        private String majorEngineVersion;

        private String minimumRequiredMinorEngineVersion;

        private Boolean portRequired;

        private Integer defaultPort;

        private List<String> optionsDependedOn = DefaultSdkAutoConstructList.getInstance();

        private List<String> optionsConflictsWith = DefaultSdkAutoConstructList.getInstance();

        private Boolean persistent;

        private Boolean permanent;

        private Boolean requiresAutoMinorEngineVersionUpgrade;

        private Boolean vpcOnly;

        private Boolean supportsOptionVersionDowngrade;

        private List<OptionGroupOptionSetting> optionGroupOptionSettings = DefaultSdkAutoConstructList.getInstance();

        private List<OptionVersion> optionGroupOptionVersions = DefaultSdkAutoConstructList.getInstance();

        private Boolean copyableCrossAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroupOption model) {
            name(model.name);
            description(model.description);
            engineName(model.engineName);
            majorEngineVersion(model.majorEngineVersion);
            minimumRequiredMinorEngineVersion(model.minimumRequiredMinorEngineVersion);
            portRequired(model.portRequired);
            defaultPort(model.defaultPort);
            optionsDependedOn(model.optionsDependedOn);
            optionsConflictsWith(model.optionsConflictsWith);
            persistent(model.persistent);
            permanent(model.permanent);
            requiresAutoMinorEngineVersionUpgrade(model.requiresAutoMinorEngineVersionUpgrade);
            vpcOnly(model.vpcOnly);
            supportsOptionVersionDowngrade(model.supportsOptionVersionDowngrade);
            optionGroupOptionSettings(model.optionGroupOptionSettings);
            optionGroupOptionVersions(model.optionGroupOptionVersions);
            copyableCrossAccount(model.copyableCrossAccount);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineName() {
            return engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getMajorEngineVersion() {
            return majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final String getMinimumRequiredMinorEngineVersion() {
            return minimumRequiredMinorEngineVersion;
        }

        public final void setMinimumRequiredMinorEngineVersion(String minimumRequiredMinorEngineVersion) {
            this.minimumRequiredMinorEngineVersion = minimumRequiredMinorEngineVersion;
        }

        @Override
        public final Builder minimumRequiredMinorEngineVersion(String minimumRequiredMinorEngineVersion) {
            this.minimumRequiredMinorEngineVersion = minimumRequiredMinorEngineVersion;
            return this;
        }

        public final Boolean getPortRequired() {
            return portRequired;
        }

        public final void setPortRequired(Boolean portRequired) {
            this.portRequired = portRequired;
        }

        @Override
        public final Builder portRequired(Boolean portRequired) {
            this.portRequired = portRequired;
            return this;
        }

        public final Integer getDefaultPort() {
            return defaultPort;
        }

        public final void setDefaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
        }

        @Override
        public final Builder defaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        public final Collection<String> getOptionsDependedOn() {
            if (optionsDependedOn instanceof SdkAutoConstructList) {
                return null;
            }
            return optionsDependedOn;
        }

        public final void setOptionsDependedOn(Collection<String> optionsDependedOn) {
            this.optionsDependedOn = OptionsDependedOnCopier.copy(optionsDependedOn);
        }

        @Override
        public final Builder optionsDependedOn(Collection<String> optionsDependedOn) {
            this.optionsDependedOn = OptionsDependedOnCopier.copy(optionsDependedOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsDependedOn(String... optionsDependedOn) {
            optionsDependedOn(Arrays.asList(optionsDependedOn));
            return this;
        }

        public final Collection<String> getOptionsConflictsWith() {
            if (optionsConflictsWith instanceof SdkAutoConstructList) {
                return null;
            }
            return optionsConflictsWith;
        }

        public final void setOptionsConflictsWith(Collection<String> optionsConflictsWith) {
            this.optionsConflictsWith = OptionsConflictsWithCopier.copy(optionsConflictsWith);
        }

        @Override
        public final Builder optionsConflictsWith(Collection<String> optionsConflictsWith) {
            this.optionsConflictsWith = OptionsConflictsWithCopier.copy(optionsConflictsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsConflictsWith(String... optionsConflictsWith) {
            optionsConflictsWith(Arrays.asList(optionsConflictsWith));
            return this;
        }

        public final Boolean getPersistent() {
            return persistent;
        }

        public final void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        @Override
        public final Builder persistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public final Boolean getPermanent() {
            return permanent;
        }

        public final void setPermanent(Boolean permanent) {
            this.permanent = permanent;
        }

        @Override
        public final Builder permanent(Boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public final Boolean getRequiresAutoMinorEngineVersionUpgrade() {
            return requiresAutoMinorEngineVersionUpgrade;
        }

        public final void setRequiresAutoMinorEngineVersionUpgrade(Boolean requiresAutoMinorEngineVersionUpgrade) {
            this.requiresAutoMinorEngineVersionUpgrade = requiresAutoMinorEngineVersionUpgrade;
        }

        @Override
        public final Builder requiresAutoMinorEngineVersionUpgrade(Boolean requiresAutoMinorEngineVersionUpgrade) {
            this.requiresAutoMinorEngineVersionUpgrade = requiresAutoMinorEngineVersionUpgrade;
            return this;
        }

        public final Boolean getVpcOnly() {
            return vpcOnly;
        }

        public final void setVpcOnly(Boolean vpcOnly) {
            this.vpcOnly = vpcOnly;
        }

        @Override
        public final Builder vpcOnly(Boolean vpcOnly) {
            this.vpcOnly = vpcOnly;
            return this;
        }

        public final Boolean getSupportsOptionVersionDowngrade() {
            return supportsOptionVersionDowngrade;
        }

        public final void setSupportsOptionVersionDowngrade(Boolean supportsOptionVersionDowngrade) {
            this.supportsOptionVersionDowngrade = supportsOptionVersionDowngrade;
        }

        @Override
        public final Builder supportsOptionVersionDowngrade(Boolean supportsOptionVersionDowngrade) {
            this.supportsOptionVersionDowngrade = supportsOptionVersionDowngrade;
            return this;
        }

        public final List<OptionGroupOptionSetting.Builder> getOptionGroupOptionSettings() {
            List<OptionGroupOptionSetting.Builder> result = OptionGroupOptionSettingsListCopier
                    .copyToBuilder(this.optionGroupOptionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionGroupOptionSettings(Collection<OptionGroupOptionSetting.BuilderImpl> optionGroupOptionSettings) {
            this.optionGroupOptionSettings = OptionGroupOptionSettingsListCopier.copyFromBuilder(optionGroupOptionSettings);
        }

        @Override
        public final Builder optionGroupOptionSettings(Collection<OptionGroupOptionSetting> optionGroupOptionSettings) {
            this.optionGroupOptionSettings = OptionGroupOptionSettingsListCopier.copy(optionGroupOptionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionSettings(OptionGroupOptionSetting... optionGroupOptionSettings) {
            optionGroupOptionSettings(Arrays.asList(optionGroupOptionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionSettings(Consumer<OptionGroupOptionSetting.Builder>... optionGroupOptionSettings) {
            optionGroupOptionSettings(Stream.of(optionGroupOptionSettings)
                    .map(c -> OptionGroupOptionSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OptionVersion.Builder> getOptionGroupOptionVersions() {
            List<OptionVersion.Builder> result = OptionGroupOptionVersionsListCopier
                    .copyToBuilder(this.optionGroupOptionVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionGroupOptionVersions(Collection<OptionVersion.BuilderImpl> optionGroupOptionVersions) {
            this.optionGroupOptionVersions = OptionGroupOptionVersionsListCopier.copyFromBuilder(optionGroupOptionVersions);
        }

        @Override
        public final Builder optionGroupOptionVersions(Collection<OptionVersion> optionGroupOptionVersions) {
            this.optionGroupOptionVersions = OptionGroupOptionVersionsListCopier.copy(optionGroupOptionVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionVersions(OptionVersion... optionGroupOptionVersions) {
            optionGroupOptionVersions(Arrays.asList(optionGroupOptionVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionVersions(Consumer<OptionVersion.Builder>... optionGroupOptionVersions) {
            optionGroupOptionVersions(Stream.of(optionGroupOptionVersions)
                    .map(c -> OptionVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCopyableCrossAccount() {
            return copyableCrossAccount;
        }

        public final void setCopyableCrossAccount(Boolean copyableCrossAccount) {
            this.copyableCrossAccount = copyableCrossAccount;
        }

        @Override
        public final Builder copyableCrossAccount(Boolean copyableCrossAccount) {
            this.copyableCrossAccount = copyableCrossAccount;
            return this;
        }

        @Override
        public OptionGroupOption build() {
            return new OptionGroupOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
