/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The query to retrieve metric data points.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricQuery implements SdkPojo, Serializable, ToCopyableBuilder<MetricQuery.Builder, MetricQuery> {
    private static final SdkField<PerformanceInsightsMetricQuery> PERFORMANCE_INSIGHTS_METRIC_QUERY_FIELD = SdkField
            .<PerformanceInsightsMetricQuery> builder(MarshallingType.SDK_POJO)
            .memberName("PerformanceInsightsMetricQuery")
            .getter(getter(MetricQuery::performanceInsightsMetricQuery))
            .setter(setter(Builder::performanceInsightsMetricQuery))
            .constructor(PerformanceInsightsMetricQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsMetricQuery")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PERFORMANCE_INSIGHTS_METRIC_QUERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final PerformanceInsightsMetricQuery performanceInsightsMetricQuery;

    private MetricQuery(BuilderImpl builder) {
        this.performanceInsightsMetricQuery = builder.performanceInsightsMetricQuery;
    }

    /**
     * <p>
     * The Performance Insights query that you can use to retrieve Performance Insights metric data points.
     * </p>
     * 
     * @return The Performance Insights query that you can use to retrieve Performance Insights metric data points.
     */
    public final PerformanceInsightsMetricQuery performanceInsightsMetricQuery() {
        return performanceInsightsMetricQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsMetricQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricQuery)) {
            return false;
        }
        MetricQuery other = (MetricQuery) obj;
        return Objects.equals(performanceInsightsMetricQuery(), other.performanceInsightsMetricQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricQuery").add("PerformanceInsightsMetricQuery", performanceInsightsMetricQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PerformanceInsightsMetricQuery":
            return Optional.ofNullable(clazz.cast(performanceInsightsMetricQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricQuery, T> g) {
        return obj -> g.apply((MetricQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricQuery> {
        /**
         * <p>
         * The Performance Insights query that you can use to retrieve Performance Insights metric data points.
         * </p>
         * 
         * @param performanceInsightsMetricQuery
         *        The Performance Insights query that you can use to retrieve Performance Insights metric data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsMetricQuery(PerformanceInsightsMetricQuery performanceInsightsMetricQuery);

        /**
         * <p>
         * The Performance Insights query that you can use to retrieve Performance Insights metric data points.
         * </p>
         * This is a convenience method that creates an instance of the {@link PerformanceInsightsMetricQuery.Builder}
         * avoiding the need to create one manually via {@link PerformanceInsightsMetricQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceInsightsMetricQuery.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #performanceInsightsMetricQuery(PerformanceInsightsMetricQuery)}.
         * 
         * @param performanceInsightsMetricQuery
         *        a consumer that will call methods on {@link PerformanceInsightsMetricQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performanceInsightsMetricQuery(PerformanceInsightsMetricQuery)
         */
        default Builder performanceInsightsMetricQuery(
                Consumer<PerformanceInsightsMetricQuery.Builder> performanceInsightsMetricQuery) {
            return performanceInsightsMetricQuery(PerformanceInsightsMetricQuery.builder()
                    .applyMutation(performanceInsightsMetricQuery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PerformanceInsightsMetricQuery performanceInsightsMetricQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricQuery model) {
            performanceInsightsMetricQuery(model.performanceInsightsMetricQuery);
        }

        public final PerformanceInsightsMetricQuery.Builder getPerformanceInsightsMetricQuery() {
            return performanceInsightsMetricQuery != null ? performanceInsightsMetricQuery.toBuilder() : null;
        }

        public final void setPerformanceInsightsMetricQuery(
                PerformanceInsightsMetricQuery.BuilderImpl performanceInsightsMetricQuery) {
            this.performanceInsightsMetricQuery = performanceInsightsMetricQuery != null ? performanceInsightsMetricQuery.build()
                    : null;
        }

        @Override
        public final Builder performanceInsightsMetricQuery(PerformanceInsightsMetricQuery performanceInsightsMetricQuery) {
            this.performanceInsightsMetricQuery = performanceInsightsMetricQuery;
            return this;
        }

        @Override
        public MetricQuery build() {
            return new MetricQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
