/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * (Amazon SQS only) The scaling configuration for the event source. To remove the configuration, pass an empty value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingConfig implements SdkPojo, Serializable, ToCopyableBuilder<ScalingConfig.Builder, ScalingConfig> {
    private static final SdkField<Integer> MAXIMUM_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumConcurrency").getter(getter(ScalingConfig::maximumConcurrency))
            .setter(setter(Builder::maximumConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumConcurrency").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_CONCURRENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maximumConcurrency;

    private ScalingConfig(BuilderImpl builder) {
        this.maximumConcurrency = builder.maximumConcurrency;
    }

    /**
     * <p>
     * Limits the number of concurrent instances that the Amazon SQS event source can invoke.
     * </p>
     * 
     * @return Limits the number of concurrent instances that the Amazon SQS event source can invoke.
     */
    public final Integer maximumConcurrency() {
        return maximumConcurrency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumConcurrency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfig)) {
            return false;
        }
        ScalingConfig other = (ScalingConfig) obj;
        return Objects.equals(maximumConcurrency(), other.maximumConcurrency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingConfig").add("MaximumConcurrency", maximumConcurrency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumConcurrency":
            return Optional.ofNullable(clazz.cast(maximumConcurrency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaximumConcurrency", MAXIMUM_CONCURRENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfig, T> g) {
        return obj -> g.apply((ScalingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingConfig> {
        /**
         * <p>
         * Limits the number of concurrent instances that the Amazon SQS event source can invoke.
         * </p>
         * 
         * @param maximumConcurrency
         *        Limits the number of concurrent instances that the Amazon SQS event source can invoke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumConcurrency(Integer maximumConcurrency);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumConcurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfig model) {
            maximumConcurrency(model.maximumConcurrency);
        }

        public final Integer getMaximumConcurrency() {
            return maximumConcurrency;
        }

        public final void setMaximumConcurrency(Integer maximumConcurrency) {
            this.maximumConcurrency = maximumConcurrency;
        }

        @Override
        public final Builder maximumConcurrency(Integer maximumConcurrency) {
            this.maximumConcurrency = maximumConcurrency;
            return this;
        }

        @Override
        public ScalingConfig build() {
            return new ScalingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
