/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRuntimeManagementConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<GetRuntimeManagementConfigResponse.Builder, GetRuntimeManagementConfigResponse> {
    private static final SdkField<String> UPDATE_RUNTIME_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateRuntimeOn").getter(getter(GetRuntimeManagementConfigResponse::updateRuntimeOnAsString))
            .setter(setter(Builder::updateRuntimeOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateRuntimeOn").build()).build();

    private static final SdkField<String> RUNTIME_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeVersionArn").getter(getter(GetRuntimeManagementConfigResponse::runtimeVersionArn))
            .setter(setter(Builder::runtimeVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersionArn").build()).build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn").getter(getter(GetRuntimeManagementConfigResponse::functionArn))
            .setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_RUNTIME_ON_FIELD,
            RUNTIME_VERSION_ARN_FIELD, FUNCTION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String updateRuntimeOn;

    private final String runtimeVersionArn;

    private final String functionArn;

    private GetRuntimeManagementConfigResponse(BuilderImpl builder) {
        super(builder);
        this.updateRuntimeOn = builder.updateRuntimeOn;
        this.runtimeVersionArn = builder.runtimeVersionArn;
        this.functionArn = builder.functionArn;
    }

    /**
     * <p>
     * The current runtime update mode of the function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateRuntimeOn}
     * will return {@link UpdateRuntimeOn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateRuntimeOnAsString}.
     * </p>
     * 
     * @return The current runtime update mode of the function.
     * @see UpdateRuntimeOn
     */
    public final UpdateRuntimeOn updateRuntimeOn() {
        return UpdateRuntimeOn.fromValue(updateRuntimeOn);
    }

    /**
     * <p>
     * The current runtime update mode of the function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateRuntimeOn}
     * will return {@link UpdateRuntimeOn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateRuntimeOnAsString}.
     * </p>
     * 
     * @return The current runtime update mode of the function.
     * @see UpdateRuntimeOn
     */
    public final String updateRuntimeOnAsString() {
        return updateRuntimeOn;
    }

    /**
     * <p>
     * The ARN of the runtime the function is configured to use. If the runtime update mode is <b>Manual</b>, the ARN is
     * returned, otherwise <code>null</code> is returned.
     * </p>
     * 
     * @return The ARN of the runtime the function is configured to use. If the runtime update mode is <b>Manual</b>,
     *         the ARN is returned, otherwise <code>null</code> is returned.
     */
    public final String runtimeVersionArn() {
        return runtimeVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of your function.
     */
    public final String functionArn() {
        return functionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateRuntimeOnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRuntimeManagementConfigResponse)) {
            return false;
        }
        GetRuntimeManagementConfigResponse other = (GetRuntimeManagementConfigResponse) obj;
        return Objects.equals(updateRuntimeOnAsString(), other.updateRuntimeOnAsString())
                && Objects.equals(runtimeVersionArn(), other.runtimeVersionArn())
                && Objects.equals(functionArn(), other.functionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRuntimeManagementConfigResponse").add("UpdateRuntimeOn", updateRuntimeOnAsString())
                .add("RuntimeVersionArn", runtimeVersionArn()).add("FunctionArn", functionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateRuntimeOn":
            return Optional.ofNullable(clazz.cast(updateRuntimeOnAsString()));
        case "RuntimeVersionArn":
            return Optional.ofNullable(clazz.cast(runtimeVersionArn()));
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UpdateRuntimeOn", UPDATE_RUNTIME_ON_FIELD);
        map.put("RuntimeVersionArn", RUNTIME_VERSION_ARN_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRuntimeManagementConfigResponse, T> g) {
        return obj -> g.apply((GetRuntimeManagementConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRuntimeManagementConfigResponse> {
        /**
         * <p>
         * The current runtime update mode of the function.
         * </p>
         * 
         * @param updateRuntimeOn
         *        The current runtime update mode of the function.
         * @see UpdateRuntimeOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRuntimeOn
         */
        Builder updateRuntimeOn(String updateRuntimeOn);

        /**
         * <p>
         * The current runtime update mode of the function.
         * </p>
         * 
         * @param updateRuntimeOn
         *        The current runtime update mode of the function.
         * @see UpdateRuntimeOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRuntimeOn
         */
        Builder updateRuntimeOn(UpdateRuntimeOn updateRuntimeOn);

        /**
         * <p>
         * The ARN of the runtime the function is configured to use. If the runtime update mode is <b>Manual</b>, the
         * ARN is returned, otherwise <code>null</code> is returned.
         * </p>
         * 
         * @param runtimeVersionArn
         *        The ARN of the runtime the function is configured to use. If the runtime update mode is <b>Manual</b>,
         *        the ARN is returned, otherwise <code>null</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersionArn(String runtimeVersionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of your function.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of your function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String updateRuntimeOn;

        private String runtimeVersionArn;

        private String functionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRuntimeManagementConfigResponse model) {
            super(model);
            updateRuntimeOn(model.updateRuntimeOn);
            runtimeVersionArn(model.runtimeVersionArn);
            functionArn(model.functionArn);
        }

        public final String getUpdateRuntimeOn() {
            return updateRuntimeOn;
        }

        public final void setUpdateRuntimeOn(String updateRuntimeOn) {
            this.updateRuntimeOn = updateRuntimeOn;
        }

        @Override
        public final Builder updateRuntimeOn(String updateRuntimeOn) {
            this.updateRuntimeOn = updateRuntimeOn;
            return this;
        }

        @Override
        public final Builder updateRuntimeOn(UpdateRuntimeOn updateRuntimeOn) {
            this.updateRuntimeOn(updateRuntimeOn == null ? null : updateRuntimeOn.toString());
            return this;
        }

        public final String getRuntimeVersionArn() {
            return runtimeVersionArn;
        }

        public final void setRuntimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
        }

        @Override
        public final Builder runtimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
            return this;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        @Override
        public GetRuntimeManagementConfigResponse build() {
            return new GetRuntimeManagementConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
