/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeWithResponseStreamVisitorBuilder implements InvokeWithResponseStreamResponseHandler.Visitor.Builder {
    private Consumer<InvokeWithResponseStreamResponseEvent> onDefault;

    private Consumer<InvokeResponseStreamUpdate> onPayloadChunk;

    private Consumer<InvokeWithResponseStreamCompleteEvent> onInvokeComplete;

    @Override
    public InvokeWithResponseStreamResponseHandler.Visitor.Builder onDefault(Consumer<InvokeWithResponseStreamResponseEvent> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public InvokeWithResponseStreamResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public InvokeWithResponseStreamResponseHandler.Visitor.Builder onPayloadChunk(Consumer<InvokeResponseStreamUpdate> c) {
        this.onPayloadChunk = c;
        return this;
    }

    @Override
    public InvokeWithResponseStreamResponseHandler.Visitor.Builder onInvokeComplete(
            Consumer<InvokeWithResponseStreamCompleteEvent> c) {
        this.onInvokeComplete = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements InvokeWithResponseStreamResponseHandler.Visitor {
        private final Consumer<InvokeWithResponseStreamResponseEvent> onDefault;

        private final Consumer<InvokeResponseStreamUpdate> onPayloadChunk;

        private final Consumer<InvokeWithResponseStreamCompleteEvent> onInvokeComplete;

        VisitorFromBuilder(DefaultInvokeWithResponseStreamVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : InvokeWithResponseStreamResponseHandler.Visitor.super::visitDefault;
            this.onPayloadChunk = builder.onPayloadChunk != null ? builder.onPayloadChunk
                    : InvokeWithResponseStreamResponseHandler.Visitor.super::visitPayloadChunk;
            this.onInvokeComplete = builder.onInvokeComplete != null ? builder.onInvokeComplete
                    : InvokeWithResponseStreamResponseHandler.Visitor.super::visitInvokeComplete;
        }

        @Override
        public void visitDefault(InvokeWithResponseStreamResponseEvent event) {
            onDefault.accept(event);
        }

        @Override
        public void visitPayloadChunk(InvokeResponseStreamUpdate event) {
            onPayloadChunk.accept(event);
        }

        @Override
        public void visitInvokeComplete(InvokeWithResponseStreamCompleteEvent event) {
            onInvokeComplete.accept(event);
        }
    }
}
