/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LoggerBridge;

public class CircleCiBuildServerData
extends BuildServerDataProvider {
    CircleCiBuildServerData(LoggerBridge log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("CIRCLECI");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = this.env.getOrDefault("CIRCLE_BUILD_NUM", "");
        this.maybePut(properties, "build.number", () -> buildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBranch = (String)this.env.get("CIRCLE_BRANCH");
        this.log.info("Using environment variable based branch name. CIRCLE_BRANCH = {}", (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

