/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.validation;

import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.validation.BaseValidationAdviceTrait;
import org.zalando.problem.spring.web.advice.validation.Violation;

public interface ConstraintViolationAdviceTrait
extends BaseValidationAdviceTrait {
    default public Violation createViolation(ConstraintViolation violation) {
        return new Violation(this.formatFieldName(violation.getPropertyPath().toString()), violation.getMessage());
    }

    @ExceptionHandler
    default public ResponseEntity<Problem> handleConstraintViolation(ConstraintViolationException exception, NativeWebRequest request) {
        List<Violation> violations = exception.getConstraintViolations().stream().map(this::createViolation).collect(Collectors.toList());
        return this.newConstraintViolationProblem((Throwable)exception, violations, request);
    }
}

