/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.server;

import java.io.IOException;
import javax.xml.transform.Source;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.test.server.RequestCreator;
import org.springframework.ws.test.support.creator.PayloadMessageCreator;
import org.springframework.ws.test.support.creator.SoapEnvelopeMessageCreator;
import org.springframework.ws.test.support.creator.WebServiceMessageCreator;
import org.springframework.xml.transform.ResourceSource;

public abstract class RequestCreators {
    private RequestCreators() {
    }

    public static RequestCreator withPayload(Source payload) {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        return new WebServiceMessageCreatorAdapter(new PayloadMessageCreator(payload));
    }

    public static RequestCreator withPayload(Resource payload) throws IOException {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        return RequestCreators.withPayload((Source)new ResourceSource(payload));
    }

    public static RequestCreator withSoapEnvelope(Source soapEnvelope) {
        Assert.notNull((Object)soapEnvelope, (String)"'soapEnvelope' must not be null");
        return new WebServiceMessageCreatorAdapter(new SoapEnvelopeMessageCreator(soapEnvelope));
    }

    public static RequestCreator withSoapEnvelope(Resource soapEnvelope) throws IOException {
        Assert.notNull((Object)soapEnvelope, (String)"'soapEnvelope' must not be null");
        return RequestCreators.withSoapEnvelope((Source)new ResourceSource(soapEnvelope));
    }

    private static class WebServiceMessageCreatorAdapter
    implements RequestCreator {
        private final WebServiceMessageCreator adaptee;

        private WebServiceMessageCreatorAdapter(WebServiceMessageCreator adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public WebServiceMessage createRequest(WebServiceMessageFactory messageFactory) throws IOException {
            return this.adaptee.createMessage(messageFactory);
        }
    }
}

